/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import pt.webdetails.cda.exporter.AbstractExporter;
import pt.webdetails.cda.exporter.ExporterException;

public class HtmlExporter
extends AbstractExporter {
    private static final Log logger = LogFactory.getLog(HtmlExporter.class);
    private static final String MIME_TYPE = "text/html";
    private static final String DEFAULT_TITLE = "CDA HTML Export";
    private static final String NULL = "#NULL";
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private String title = "CDA HTML Export";
    private boolean fullHtml = false;

    public HtmlExporter(Map<String, String> extraSettings) {
        String fullHtmlParam;
        String titleParam;
        String providedFormat = extraSettings.get("dateFormat");
        if (providedFormat != null) {
            try {
                this.format = new SimpleDateFormat(providedFormat);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"Invalid date format", (Throwable)e);
            }
        }
        if ((titleParam = extraSettings.get("title")) != null) {
            this.title = titleParam;
        }
        if ((fullHtmlParam = extraSettings.get("fullHtml")) != null) {
            this.fullHtml = Boolean.parseBoolean(fullHtmlParam);
        }
    }

    @Override
    public void export(OutputStream out, TableModel tableModel) throws ExporterException {
        int i;
        Document document = DocumentHelper.createDocument();
        Element table = null;
        if (this.fullHtml) {
            Element html = document.addElement("html");
            Element head = html.addElement("head");
            head.addElement("title").addText(this.title);
            table = html.addElement("body").addElement("table");
        } else {
            table = document.addElement("table");
        }
        int columnCount = tableModel.getColumnCount();
        Element headerRow = table.addElement("tr");
        for (i = 0; i < columnCount; ++i) {
            String colName = tableModel.getColumnName(i);
            headerRow.addElement("th").addText(colName);
        }
        for (i = 0; i < tableModel.getRowCount(); ++i) {
            Element row = table.addElement("tr");
            for (int j = 0; j < columnCount; ++j) {
                Element tableCell = row.addElement("td");
                Object value = tableModel.getValueAt(i, j);
                tableCell.setText(this.valueToText(value));
                if (value instanceof Date) {
                    tableCell.setText(this.format.format(value));
                    continue;
                }
                if (value == null) continue;
                tableCell.setText(value.toString());
            }
        }
        try {
            document.setXMLEncoding("UTF-8");
            OutputFormat outFormat = new OutputFormat();
            outFormat.setOmitEncoding(true);
            outFormat.setSuppressDeclaration(true);
            outFormat.setNewlines(true);
            outFormat.setIndentSize(columnCount);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, outFormat);
            xmlWriter.write(document);
            xmlWriter.flush();
        }
        catch (IOException e) {
            throw new ExporterException("IO Exception converting to utf-8", e);
        }
    }

    private String valueToText(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof Date) {
            return this.format.format((Date)value);
        }
        return value.toString();
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    public String getExtension() {
        return "html";
    }

    @Override
    public String getAttachmentName() {
        return null;
    }

    private static final class ExtraSettings {
        private static final String DATE_FORMAT = "dateFormat";
        private static final String TITLE = "title";
        private static final String FULL_HTML = "fullHtml";

        private ExtraSettings() {
        }
    }
}

