/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class DataTableFilter {
    private static final String TERM_SEPARATOR = " ";
    private String[] searchTerms;
    private int[] searchableColumns;

    public DataTableFilter(String searchText, int[] searchableColumns) {
        if (searchableColumns == null || searchText == null) {
            throw new IllegalArgumentException(DataTableFilter.class.getName() + " cannot have null arguments.");
        }
        this.searchableColumns = searchableColumns;
        this.searchTerms = StringUtils.split((String)searchText, (String)TERM_SEPARATOR);
    }

    public boolean rowContainsSearchTerms(TableModel table, int rowIndex) {
        String[] columnValues = this.getRelevantColumns(table, rowIndex);
        for (String searchTerm : this.searchTerms) {
            boolean containsTerm = false;
            for (String value : columnValues) {
                if (!StringUtils.containsIgnoreCase((String)value, (String)searchTerm)) continue;
                containsTerm = true;
            }
            if (containsTerm) continue;
            return false;
        }
        return true;
    }

    private String[] getRelevantColumns(TableModel table, int rowIndex) {
        String[] row = new String[this.searchableColumns.length];
        for (int i = 0; i < row.length; ++i) {
            Object rawValue = table.getValueAt(rowIndex, this.searchableColumns[i]);
            row[i] = rawValue == null ? null : rawValue.toString();
        }
        return row;
    }
}

