/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.dataaccess.InvalidParameterException;

public class FormulaEvaluator {
    private static final String FORMULA_BEGIN = "${";
    private static final String FORMULA_END = "}";

    public static String replaceFormula(String text) {
        if (!StringUtils.contains((String)text, (String)FORMULA_BEGIN)) {
            return text;
        }
        try {
            FormulaContext formulaContext = CdaEngine.getEnvironment().getFormulaContext();
            return FormulaEvaluator.replaceFormula(text, formulaContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String replaceFormula(String text, FormulaContext context) throws InvalidParameterException {
        int startIdx = StringUtils.indexOf((String)text, (String)FORMULA_BEGIN);
        int contentStartIdx = startIdx + FORMULA_BEGIN.length();
        if (startIdx > -1) {
            int contentEndIdx = StringUtils.lastIndexOf((String)text, (String)FORMULA_END);
            int endIdx = contentEndIdx + FORMULA_END.length();
            if (contentEndIdx >= contentStartIdx) {
                String contents = StringUtils.substring((String)text, (int)contentStartIdx, (int)contentEndIdx);
                StringBuilder result = new StringBuilder();
                result.append(StringUtils.substring((String)text, (int)0, (int)startIdx));
                result.append(FormulaEvaluator.processFormula(contents, context));
                result.append(StringUtils.substring((String)text, (int)endIdx, (int)text.length()));
                return result.toString();
            }
        }
        return text;
    }

    public static Object processFormula(String localValue) throws InvalidParameterException {
        return FormulaEvaluator.processFormula(localValue, null);
    }

    public static Object processFormula(String localValue, FormulaContext formulaContext) throws InvalidParameterException {
        try {
            Formula formula = new Formula(localValue);
            if (formulaContext == null) {
                formulaContext = CdaEngine.getEnvironment().getFormulaContext();
            }
            formula.initialize(formulaContext);
            Object[] result = formula.evaluate();
            if (result instanceof ArrayList) {
                result = ((ArrayList)result).toArray();
            }
            return result;
        }
        catch (ParseException e) {
            throw new InvalidParameterException("Unable to parse expression " + localValue, (Exception)((Object)e));
        }
        catch (EvaluationException e) {
            throw new InvalidParameterException("Unable to evaluate expression " + localValue, (Exception)((Object)e));
        }
    }
}

