/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.kettle;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.utils.kettle.SortException;

public class SortableTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(SortableTableModel.class);
    private TableModel base;
    private Integer[] sortedIndices;

    public SortableTableModel(TableModel base) {
        this.base = base;
        this.sortedIndices = new Integer[base.getRowCount()];
        for (int i = 0; i < this.sortedIndices.length; ++i) {
            this.sortedIndices[i] = i;
        }
    }

    @Override
    public int getRowCount() {
        return this.base.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.base.getColumnCount();
    }

    @Override
    public String getColumnName(int idx) {
        return this.base.getColumnName(idx);
    }

    @Override
    public Class<?> getColumnClass(int idx) {
        return this.base.getColumnClass(idx);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.base.removeTableModelListener(l);
    }

    @Override
    public Object getValueAt(int i, int i1) {
        return this.base.getValueAt(this.sortedIndices[i], i1);
    }

    @Override
    public void setValueAt(Object val, int i, int i1) {
        this.base.setValueAt(val, this.sortedIndices[i], i1);
    }

    @Override
    public boolean isCellEditable(int i, int i1) {
        return this.base.isCellEditable(this.sortedIndices[i], i1);
    }

    public void sort() {
        List<Integer> idxs = Arrays.asList(this.sortedIndices);
        Collections.sort(idxs);
        this.sortedIndices = idxs.toArray(this.sortedIndices);
    }

    public void sort(Class<? extends Comparator<Integer>> klass, List<String> sortBy) throws ClassCastException, SortException {
        if (!Comparator.class.isAssignableFrom(klass)) {
            ClassCastException e = new ClassCastException("Need a Comparator");
            logger.error((Object)e);
            throw e;
        }
        try {
            Comparator<Integer> comp = klass.getConstructor(TableModel.class, List.class).newInstance(this.base, sortBy);
            List<Integer> idxs = Arrays.asList(this.sortedIndices);
            Collections.sort(idxs, comp);
            this.sortedIndices = idxs.toArray(this.sortedIndices);
        }
        catch (Exception e) {
            if (e instanceof NoSuchMethodException || e instanceof InstantiationException) {
                ClassCastException se = new ClassCastException("Invalid Comparator");
                logger.error((Object)se);
                throw se;
            }
            SortException se = new SortException("Couldn't sort", e);
            logger.error((Object)se);
            throw se;
        }
    }
}

