/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.xml;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.kettle.TransFromFileConnection;
import pt.webdetails.cda.connections.kettle.TransFromFileConnectionInfo;
import pt.webdetails.cda.connections.metadata.MetadataConnection;
import pt.webdetails.cda.connections.metadata.MetadataConnectionInfo;
import pt.webdetails.cda.connections.mondrian.JdbcConnection;
import pt.webdetails.cda.connections.mondrian.JdbcConnectionInfo;
import pt.webdetails.cda.connections.mondrian.MondrianJndiConnectionInfo;
import pt.webdetails.cda.connections.olap4j.DefaultOlap4jConnection;
import pt.webdetails.cda.connections.olap4j.Olap4jConnectionInfo;
import pt.webdetails.cda.connections.scripting.ScriptingConnection;
import pt.webdetails.cda.connections.scripting.ScriptingConnectionInfo;
import pt.webdetails.cda.connections.sql.JndiConnection;
import pt.webdetails.cda.connections.sql.SqlJndiConnectionInfo;
import pt.webdetails.cda.connections.xpath.XPathConnection;
import pt.webdetails.cda.connections.xpath.XPathConnectionInfo;
import pt.webdetails.cda.dataaccess.ColumnDefinition;
import pt.webdetails.cda.dataaccess.CompoundDataAccess;
import pt.webdetails.cda.dataaccess.JoinCompoundDataAccess;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.SimpleDataAccess;
import pt.webdetails.cda.dataaccess.UnionCompoundDataAccess;

public class DomVisitor {
    public void visit(AbstractConnection con, Element ele) {
        Element conEle = ele.addElement("Connection");
        conEle.addAttribute("id", con.getId());
        conEle.addAttribute("type", con.getTypeForFile());
        if (con instanceof MetadataConnection) {
            this.visit((MetadataConnection)con, conEle);
        } else if (con instanceof pt.webdetails.cda.connections.sql.JdbcConnection) {
            this.visit((pt.webdetails.cda.connections.sql.JdbcConnection)con, conEle);
        } else if (con instanceof JndiConnection) {
            this.visit((JndiConnection)con, conEle);
        } else if (con instanceof JdbcConnection) {
            this.visit((JdbcConnection)con, conEle);
        } else if (con instanceof pt.webdetails.cda.connections.mondrian.JndiConnection) {
            this.visit((pt.webdetails.cda.connections.mondrian.JndiConnection)con, conEle);
        } else if (con instanceof DefaultOlap4jConnection) {
            this.visit((DefaultOlap4jConnection)con, conEle);
        } else if (con instanceof ScriptingConnection) {
            this.visit((ScriptingConnection)con, conEle);
        } else if (con instanceof XPathConnection) {
            this.visit((XPathConnection)con, conEle);
        } else if (con instanceof TransFromFileConnection) {
            this.visit((TransFromFileConnection)con, conEle);
        }
    }

    private void visit(MetadataConnection con, Element ele) {
        MetadataConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("XmiFile").addText(conInfo.getXmiFile());
        ele.addElement("DomainId").addText(conInfo.getDomainId());
    }

    private void visit(pt.webdetails.cda.connections.sql.JdbcConnection con, Element ele) {
        pt.webdetails.cda.connections.sql.JdbcConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("Driver").addText(conInfo.getDriver());
        ele.addElement("Url").addText(conInfo.getUrl());
        ele.addElement("User").addText(conInfo.getUser());
        ele.addElement("Pass").addText(DomVisitor.nvl(conInfo.getPass()));
    }

    private void visit(JndiConnection con, Element ele) {
        SqlJndiConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("Jndi").addText(conInfo.getJndi());
    }

    private void visit(JdbcConnection con, Element ele) {
        JdbcConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("Driver").addText(conInfo.getDriver());
        ele.addElement("Url").addText(conInfo.getUrl());
        ele.addElement("User").addText(conInfo.getUser());
        ele.addElement("Pass").addText(DomVisitor.nvl(conInfo.getPass()));
        ele.addElement("Catalog").addText(conInfo.getCatalog());
        ele.addElement("Cube").addText(conInfo.getCube());
    }

    private void visit(pt.webdetails.cda.connections.mondrian.JndiConnection con, Element ele) {
        MondrianJndiConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("Jndi").addText(conInfo.getJndi());
        ele.addElement("Catalog").addText(conInfo.getCatalog());
        ele.addElement("Cube").addText(conInfo.getCube());
    }

    private void visit(DefaultOlap4jConnection con, Element ele) {
        Olap4jConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("Driver").addText(conInfo.getDriver());
        ele.addElement("Url").addText(conInfo.getUrl());
        ele.addElement("User").addText(conInfo.getUser());
        ele.addElement("Pass").addText(conInfo.getPass());
        ele.addElement("Role").addText(conInfo.getRole());
        for (Object key : conInfo.getProperties().keySet()) {
            String k = key.toString();
            String v = conInfo.getProperties().getProperty(k);
            ele.addElement("Property").addAttribute("name", k).addText(v);
        }
    }

    private void visit(ScriptingConnection con, Element ele) {
        ScriptingConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("Language").addText(conInfo.getLanguage());
        ele.addElement("InitScript").addText(DomVisitor.nvl(conInfo.getInitScript()));
    }

    private void visit(XPathConnection con, Element ele) {
        XPathConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("DataFile").addText(conInfo.getXqueryDataFile());
    }

    private void visit(TransFromFileConnection con, Element ele) {
        TransFromFileConnectionInfo conInfo = con.getConnectionInfo();
        ele.addElement("KtrFile").addText(conInfo.getTransformationFile());
        ParameterMapping[] variables = conInfo.getDefinedVariableNames();
        for (int i = 0; i < variables.length; ++i) {
            ParameterMapping var = variables[i];
            Element vars = ele.addElement("variables").addAttribute("datarow-name", var.getName());
            if (var.getName().equals(var.getAlias())) continue;
            vars.addAttribute("variable-name", var.getAlias());
        }
    }

    public void visit(SimpleDataAccess da, Element daEle) {
        daEle.addAttribute("id", da.getId());
        daEle.addAttribute("connection", da.getConnectionId());
        daEle.addAttribute("type", da.getType());
        daEle.addAttribute("access", da.getAccess().name().toLowerCase());
        if (da.isCacheEnabled()) {
            daEle.addAttribute("cache", new Boolean(da.isCacheEnabled()).toString());
        }
        if (da.getCacheDuration() != 3600) {
            daEle.addAttribute("cacheDuration", "" + da.getCacheDuration());
        }
        daEle.addElement("Name").addText(da.getName());
        daEle.addElement("Query").addCDATA(da.getQuery());
    }

    public void visit(CompoundDataAccess da, Element daEle) {
        daEle.addAttribute("id", da.getId());
        daEle.addAttribute("type", da.getType());
        if (da instanceof UnionCompoundDataAccess) {
            UnionCompoundDataAccess uDa = (UnionCompoundDataAccess)da;
            daEle.addElement("Top").addAttribute("id", uDa.getTopId());
            daEle.addElement("Bottom").addAttribute("id", uDa.getBottomId());
        } else if (da instanceof JoinCompoundDataAccess) {
            JoinCompoundDataAccess jDa = (JoinCompoundDataAccess)da;
            daEle.addElement("Left").addAttribute("id", jDa.getLeftId()).addAttribute("keys", StringUtils.join((Object[])jDa.getLeftKeys(), (String)","));
            daEle.addElement("Right").addAttribute("id", jDa.getRightId()).addAttribute("keys", StringUtils.join((Object[])jDa.getRightKeys(), (String)","));
        }
    }

    public void visit(ColumnDefinition columnDefinition, Element daEle) {
        Element colEle = null;
        if (columnDefinition.getType().equals((Object)ColumnDefinition.TYPE.COLUMN)) {
            colEle = daEle.addElement("Column");
            colEle.addAttribute("idx", columnDefinition.getIndex().toString());
            colEle.addElement("Name").addText(columnDefinition.getName());
        } else {
            colEle = daEle.addElement("CalculatedColumn");
            colEle.addElement("Name").addText(columnDefinition.getName());
            colEle.addElement("Formula").addText(columnDefinition.getFormula());
        }
    }

    public void visit(Parameter parameter, Element daEle) {
        Element paramEle = daEle.addElement("Parameter");
        paramEle.addAttribute("name", parameter.getName());
        paramEle.addAttribute("type", parameter.getTypeAsString());
        if (parameter.getPattern() != null) {
            paramEle.addAttribute("pattern", parameter.getPattern());
        }
        paramEle.addAttribute("default", parameter.getDefaultValue().toString());
        paramEle.addAttribute("separator", parameter.getSeparator());
        if (parameter.getAccess().equals((Object)Parameter.Access.PRIVATE)) {
            paramEle.addAttribute("access", parameter.getAccess().name().toLowerCase());
        }
    }

    public static String nvl(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }
}

