/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.Writable;

public class Put
extends Mutation
implements HeapSize,
Writable,
Comparable<Row> {
    private static final byte PUT_VERSION = 2;
    private static final long OVERHEAD = ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 16 + 1 + ClassSize.REFERENCE + ClassSize.TREEMAP);

    public Put() {
    }

    public Put(byte[] row) {
        this(row, null);
    }

    public Put(byte[] row, RowLock rowLock) {
        this(row, Long.MAX_VALUE, rowLock);
    }

    public Put(byte[] row, long ts) {
        this(row, ts, null);
    }

    public Put(byte[] row, long ts, RowLock rowLock) {
        if (row == null || row.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row key is invalid");
        }
        this.row = Arrays.copyOf(row, row.length);
        this.ts = ts;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Put(Put putToCopy) {
        this(putToCopy.getRow(), putToCopy.ts, putToCopy.getRowLock());
        this.familyMap = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], List<KeyValue>> entry : putToCopy.getFamilyMap().entrySet()) {
            this.familyMap.put(entry.getKey(), entry.getValue());
        }
        this.writeToWAL = putToCopy.writeToWAL;
    }

    public Put add(byte[] family, byte[] qualifier, byte[] value) {
        return this.add(family, qualifier, this.ts, value);
    }

    public Put add(byte[] family, byte[] qualifier, long ts, byte[] value) {
        List<KeyValue> list = this.getKeyValueList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add(kv);
        this.familyMap.put(kv.getFamily(), list);
        return this;
    }

    public Put add(KeyValue kv) throws IOException {
        byte[] family = kv.getFamily();
        List<KeyValue> list = this.getKeyValueList(family);
        int res = Bytes.compareTo(this.row, 0, this.row.length, kv.getBuffer(), kv.getRowOffset(), kv.getRowLength());
        if (res != 0) {
            throw new IOException("The row in the recently added KeyValue " + Bytes.toStringBinary(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    private KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return new KeyValue(this.row, family, qualifier, ts, KeyValue.Type.Put, value);
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.ts, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<KeyValue> list = this.getKeyValueList(family);
        if (list.size() == 0) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            for (KeyValue kv : list) {
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || !Arrays.equals(kv.getValue(), value) || kv.getTimestamp() != ts) continue;
                return true;
            }
        } else if (ignoreValue && !ignoreTS) {
            for (KeyValue kv : list) {
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || kv.getTimestamp() != ts) continue;
                return true;
            }
        } else if (!ignoreValue && ignoreTS) {
            for (KeyValue kv : list) {
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || !Arrays.equals(kv.getValue(), value)) continue;
                return true;
            }
        } else {
            for (KeyValue kv : list) {
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    public List<KeyValue> get(byte[] family, byte[] qualifier) {
        ArrayList<KeyValue> filteredList = new ArrayList<KeyValue>();
        for (KeyValue kv : this.getKeyValueList(family)) {
            if (!Arrays.equals(kv.getQualifier(), qualifier)) continue;
            filteredList.add(kv);
        }
        return filteredList;
    }

    private List<KeyValue> getKeyValueList(byte[] family) {
        ArrayList list = (ArrayList)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList(0);
        }
        return list;
    }

    @Override
    public long heapSize() {
        long heapsize = OVERHEAD;
        heapsize += (long)ClassSize.align(ClassSize.ARRAY + this.row.length);
        heapsize += (long)ClassSize.align(this.familyMap.size() * ClassSize.MAP_ENTRY);
        for (Map.Entry entry : this.familyMap.entrySet()) {
            heapsize += (long)ClassSize.align(ClassSize.ARRAY + ((byte[])entry.getKey()).length);
            heapsize += (long)ClassSize.align(ClassSize.ARRAYLIST);
            int size = ((List)entry.getValue()).size();
            heapsize += (long)ClassSize.align(ClassSize.ARRAY + size * ClassSize.REFERENCE);
            for (KeyValue kv : (List)entry.getValue()) {
                heapsize += kv.heapSize();
            }
        }
        return ClassSize.align((int)(heapsize += this.getAttributeSize()));
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 2) {
            throw new IOException("version not supported");
        }
        this.row = Bytes.readByteArray(in);
        this.ts = in.readLong();
        this.lockId = in.readLong();
        this.writeToWAL = in.readBoolean();
        int numFamilies = in.readInt();
        if (!this.familyMap.isEmpty()) {
            this.familyMap.clear();
        }
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numKeys = in.readInt();
            ArrayList<KeyValue> keys = new ArrayList<KeyValue>(numKeys);
            int totalLen = in.readInt();
            byte[] buf = new byte[totalLen];
            int offset = 0;
            for (int j = 0; j < numKeys; ++j) {
                int keyLength = in.readInt();
                in.readFully(buf, offset, keyLength);
                keys.add(new KeyValue(buf, offset, keyLength));
                offset += keyLength;
            }
            this.familyMap.put(family, keys);
        }
        if (version > 1) {
            this.readAttributes(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.ts);
        out.writeLong(this.lockId);
        out.writeBoolean(this.writeToWAL);
        out.writeInt(this.familyMap.size());
        for (Map.Entry entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, (byte[])entry.getKey());
            List keys = (List)entry.getValue();
            out.writeInt(keys.size());
            int totalLen = 0;
            for (KeyValue kv : keys) {
                totalLen += kv.getLength();
            }
            out.writeInt(totalLen);
            for (KeyValue kv : keys) {
                out.writeInt(kv.getLength());
                out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
        }
        this.writeAttributes(out);
    }
}

