/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.GenericHFactory;

public class TableMappingRulesFactory {
    private static final Log LOG = LogFactory.getLog(TableMappingRulesFactory.class);
    private static final GenericHFactory<BaseTableMappingRules> ruleFactory_ = new GenericHFactory();
    private static volatile BaseTableMappingRules base_instance = null;

    public static BaseTableMappingRules create(Configuration conf) throws IOException {
        block6: {
            if (base_instance == null) break block6;
            return base_instance;
        }
        try {
            return ruleFactory_.getImplementorInstance(conf.get("hbase.mappingrule.impl", "com.mapr.fs.MapRTableMappingRules"), new Object[]{conf}, Configuration.class);
        }
        catch (Throwable t) {
            try {
                for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof ClassNotFoundException) && !(cause instanceof NoClassDefFoundError) || !cause.getMessage().contains("MapRTableMappingRules")) continue;
                    LOG.info((Object)"Could not find MapRTableMappingRules class in the classpath, assuming HBase only cluster.");
                    LOG.info((Object)"If you are trying to access M7 tables, add mapr-hbase jar to your classpath.");
                    LOG.debug((Object)t.getMessage(), t);
                    base_instance = BaseTableMappingRules.INSTANCE;
                    return base_instance;
                }
                throw t;
            }
            catch (Throwable e) {
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
    }

    public static boolean isHbaseOnly() {
        return base_instance != null;
    }
}

