/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class SubstringComparator
extends WritableByteArrayComparable {
    private String substr;

    public SubstringComparator() {
    }

    public SubstringComparator(String substr) {
        super(Bytes.toBytes(substr.toLowerCase()));
        this.substr = substr.toLowerCase();
    }

    @Override
    public byte[] getValue() {
        return Bytes.toBytes(this.substr);
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        return Bytes.toString(value, offset, length).toLowerCase().contains(this.substr) ? 0 : 1;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String substr = in.readUTF();
        this.value = Bytes.toBytes(substr);
        this.substr = substr;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.substr);
    }

    public String getSubstr() {
        return this.substr;
    }
}

