/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.net.SocketFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.UserProvider;
import org.apache.hadoop.hbase.ipc.HBaseClient;
import org.apache.hadoop.hbase.ipc.SecureConnectionHeader;
import org.apache.hadoop.hbase.ipc.SecureServer;
import org.apache.hadoop.hbase.ipc.Status;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.KerberosInfo;
import org.apache.hadoop.hbase.security.TokenInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.util.ReflectionUtils;

public class SecureClient
extends HBaseClient {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.SecureClient");
    public static final String IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_KEY = "hbase.ipc.client.fallback-to-simple-auth-allowed";
    public static final boolean IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_DEFAULT = false;
    protected static Map<String, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<String, TokenSelector<? extends TokenIdentifier>>();
    private final boolean fallbackAllowed;
    private UserProvider userProvider;

    public SecureClient(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory, UserProvider provider) {
        super(valueClass, conf, factory);
        this.fallbackAllowed = conf.getBoolean(IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_KEY, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fallbackAllowed=" + this.fallbackAllowed));
        }
        this.userProvider = provider;
    }

    public SecureClient(Class<? extends Writable> valueClass, Configuration conf, UserProvider provider) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory((Configuration)conf), provider);
    }

    @Override
    protected SecureConnection createConnection(HBaseClient.ConnectionId remoteId) throws IOException {
        return new SecureConnection(remoteId);
    }

    static {
        tokenHandlers.put(AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE.toString(), new AuthenticationTokenSelector());
    }

    protected class SecureConnection
    extends HBaseClient.Connection {
        private InetSocketAddress server;
        private String serverPrincipal;
        private SecureConnectionHeader header;
        private HBaseSaslRpcServer.AuthMethod authMethod;
        private boolean useSasl;
        private Token<? extends TokenIdentifier> token;
        private HBaseSaslRpcClient saslRpcClient;
        private int reloginMaxBackoff;

        public SecureConnection(HBaseClient.ConnectionId remoteId) throws IOException {
            super(remoteId);
            this.server = remoteId.getAddress();
            User ticket = remoteId.getTicket();
            Class<? extends VersionedProtocol> protocol = remoteId.getProtocol();
            this.useSasl = SecureClient.this.userProvider.isHBaseSecurityEnabled();
            if (this.useSasl && protocol != null) {
                KerberosInfo krbInfo;
                TokenInfo tokenInfo = protocol.getAnnotation(TokenInfo.class);
                if (tokenInfo != null) {
                    TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenInfo.value());
                    if (tokenSelector != null) {
                        this.token = tokenSelector.selectToken(new Text(SecureClient.this.clusterId), ticket.getUGI().getTokens());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No token selector found for type " + tokenInfo.value()));
                    }
                }
                if ((krbInfo = protocol.getAnnotation(KerberosInfo.class)) != null) {
                    String serverKey = krbInfo.serverPrincipal();
                    if (serverKey == null) {
                        throw new IOException("Can't obtain server Kerberos config key from KerberosInfo");
                    }
                    this.serverPrincipal = SecurityUtil.getServerPrincipal((String)SecureClient.this.conf.get(serverKey), (String)this.server.getAddress().getCanonicalHostName().toLowerCase());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RPC Server Kerberos principal name for protocol=" + protocol.getCanonicalName() + " is " + this.serverPrincipal));
                    }
                }
            }
            this.authMethod = !this.useSasl ? HBaseSaslRpcServer.AuthMethod.SIMPLE : (this.token != null ? HBaseSaslRpcServer.AuthMethod.DIGEST : HBaseSaslRpcServer.AuthMethod.KERBEROS);
            this.header = new SecureConnectionHeader(protocol == null ? null : protocol.getName(), ticket, this.authMethod);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for protocol " + protocol.getSimpleName()));
            }
            this.reloginMaxBackoff = SecureClient.this.conf.getInt("hbase.security.relogin.maxbackoff", 5000);
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException ioe) {
                    LOG.info((Object)"Error disposing of SASL client", (Throwable)ioe);
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == HBaseSaslRpcServer.AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
        }

        private synchronized boolean setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new HBaseSaslRpcClient(this.authMethod, this.token, this.serverPrincipal, SecureClient.this.fallbackAllowed);
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, User user) throws IOException, InterruptedException {
            user.runAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    SecureConnection.this.closeConnection();
                    if (SecureConnection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            SecureConnection.this.disposeSasl();
                            Thread.sleep(rand.nextInt(SecureConnection.this.reloginMaxBackoff) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + SecureConnection.this.serverPrincipal;
                        LOG.warn((Object)msg);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)ex;
                    }
                    if (ex instanceof SaslException) {
                        String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                        LOG.fatal((Object)msg, (Throwable)ex);
                        throw new RuntimeException(msg, ex);
                    }
                    throw new IOException(ex);
                }
            });
        }

        @Override
        protected synchronized void setupIOstreams() throws IOException, InterruptedException {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            try {
                OutputStream outStream;
                InputStream inStream;
                block11: {
                    boolean continueSasl;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    int MAX_RETRIES = 5;
                    Random rand = null;
                    while (true) {
                        UserGroupInformation ugi;
                        this.setupConnection();
                        inStream = NetUtils.getInputStream((Socket)this.socket);
                        outStream = NetUtils.getOutputStream((Socket)this.socket);
                        this.writeRpcHeader(outStream);
                        if (!this.useSasl) break block11;
                        final InputStream in2 = inStream;
                        final OutputStream out2 = outStream;
                        User ticket = this.remoteId.getTicket();
                        if (this.authMethod == HBaseSaslRpcServer.AuthMethod.KERBEROS && (ugi = ticket.getUGI()) != null && ugi.getRealUser() != null) {
                            ticket = SecureClient.this.userProvider.create(ugi.getRealUser());
                        }
                        continueSasl = false;
                        try {
                            continueSasl = ticket.runAs(new PrivilegedExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws IOException {
                                    return SecureConnection.this.setupSaslConnection(in2, out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            SecureServer.checkJCEKeyStrength();
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, 5, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream(inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                    } else {
                        this.authMethod = HBaseSaslRpcServer.AuthMethod.SIMPLE;
                        this.header = new SecureConnectionHeader(this.header.getProtocol(), this.header.getUser(), this.authMethod);
                        this.useSasl = false;
                    }
                }
                this.in = new DataInputStream(new BufferedInputStream(new HBaseClient.Connection.PingInputStream(inStream)));
                this.out = new DataOutputStream(new BufferedOutputStream(outStream));
                this.writeHeader();
                this.touch();
                this.start();
                return;
            }
            catch (IOException e) {
                this.markClosed(e);
                this.close();
                throw e;
            }
        }

        private void writeRpcHeader(OutputStream outStream) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outStream));
            out.write(SecureServer.HEADER.array());
            out.write(4);
            this.authMethod.write(out);
            out.flush();
        }

        private void writeHeader() throws IOException {
            DataOutputBuffer buf = new DataOutputBuffer();
            this.header.write((DataOutput)buf);
            int bufLen = buf.getLength();
            this.out.writeInt(bufLen);
            this.out.write(buf.getData(), 0, bufLen);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void receiveResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                int id = this.in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " got value #" + id));
                }
                HBaseClient.Call call = (HBaseClient.Call)this.calls.get(id);
                int state = this.in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("call #" + id + " state is " + state));
                }
                if (state == Status.SUCCESS.state) {
                    Writable value = (Writable)ReflectionUtils.newInstance((Class)SecureClient.this.valueClass, (Configuration)SecureClient.this.conf);
                    value.readFields((DataInput)this.in);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("call #" + id + ", response is:\n" + value.toString()));
                    }
                    if (call != null) {
                        call.setValue(value);
                    }
                } else if (state == Status.ERROR.state) {
                    if (call != null) {
                        call.setException((IOException)new RemoteException(WritableUtils.readString((DataInput)this.in), WritableUtils.readString((DataInput)this.in)));
                    }
                } else if (state == Status.FATAL.state) {
                    RemoteException exception = new RemoteException(WritableUtils.readString((DataInput)this.in), WritableUtils.readString((DataInput)this.in));
                    if (call != null) {
                        call.setException((IOException)exception);
                    }
                    this.markClosed((IOException)exception);
                }
                this.calls.remove(id);
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException && this.remoteId.rpcTimeout > 0) {
                    this.closeException = e;
                } else {
                    this.markClosed(e);
                }
            }
            finally {
                if (this.remoteId.rpcTimeout > 0) {
                    this.cleanupCalls(this.remoteId.rpcTimeout);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)"The connection is not in the closed state");
                return;
            }
            PoolMap poolMap = SecureClient.this.connections;
            synchronized (poolMap) {
                SecureClient.this.connections.remove(this.remoteId, this);
            }
            IOUtils.closeStream((Closeable)this.out);
            IOUtils.closeStream((Closeable)this.in);
            this.disposeSasl();
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)"A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing ipc connection to " + this.server + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }
    }
}

