/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ActiveMasterManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ActiveMasterManager.class);
    final AtomicBoolean clusterHasActiveMaster = new AtomicBoolean(false);
    private final ServerName sn;
    private final Server master;

    ActiveMasterManager(ZooKeeperWatcher watcher, ServerName sn, Server master) {
        super(watcher);
        this.sn = sn;
        this.master = master;
    }

    @Override
    public void nodeCreated(String path) {
        if (path.equals(this.watcher.masterAddressZNode) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.equals(this.watcher.masterAddressZNode) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterNodeChange() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.watcher.masterAddressZNode)) {
                    LOG.debug((Object)"A master is now available");
                    this.clusterHasActiveMaster.set(true);
                } else {
                    LOG.debug((Object)"No master available. Notifying waiting threads");
                    this.clusterHasActiveMaster.set(false);
                    this.clusterHasActiveMaster.notifyAll();
                }
            }
        }
        catch (KeeperException ke) {
            this.master.abort("Received an unexpected KeeperException, aborting", ke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean blockUntilBecomingActiveMaster(MonitoredTask startupStatus, ClusterStatusTracker clusterStatusTracker) {
        while (true) {
            startupStatus.setStatus("Trying to register in ZK as active master");
            try {
                String msg;
                String backupZNode = ZKUtil.joinZNode(this.watcher.backupMasterAddressesZNode, this.sn.toString());
                if (ZKUtil.createEphemeralNodeAndWatch(this.watcher, this.watcher.masterAddressZNode, this.sn.getVersionedBytes())) {
                    LOG.info((Object)("Deleting ZNode for " + backupZNode + " from backup master directory"));
                    ZKUtil.deleteNodeFailSilent(this.watcher, backupZNode);
                    startupStatus.setStatus("Successfully registered as active master.");
                    this.clusterHasActiveMaster.set(true);
                    LOG.info((Object)("Master=" + this.sn));
                    return true;
                }
                this.clusterHasActiveMaster.set(true);
                LOG.info((Object)("Adding ZNode for " + backupZNode + " in backup master directory"));
                ZKUtil.createEphemeralNodeAndWatch(this.watcher, backupZNode, this.sn.getVersionedBytes());
                byte[] bytes = ZKUtil.getDataAndWatch(this.watcher, this.watcher.masterAddressZNode);
                if (bytes == null) {
                    msg = "A master was detected, but went down before its address could be read.  Attempting to become the next active master";
                } else {
                    ServerName currentMaster = ServerName.parseVersionedServerName(bytes);
                    if (ServerName.isSameHostnameAndPort(currentMaster, this.sn)) {
                        msg = "Current master has this master's address, " + currentMaster + "; master was restarted? Deleting node.";
                        ZKUtil.deleteNode(this.watcher, this.watcher.masterAddressZNode);
                    } else {
                        msg = "Another master is the active master, " + currentMaster + "; waiting to become the next active master";
                    }
                }
                LOG.info((Object)msg);
                startupStatus.setStatus(msg);
            }
            catch (KeeperException ke) {
                this.master.abort("Received an unexpected KeeperException, aborting", ke);
                return false;
            }
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                while (this.clusterHasActiveMaster.get() && !this.master.isStopped()) {
                    try {
                        this.clusterHasActiveMaster.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Interrupted waiting for master to die", (Throwable)e);
                    }
                }
                if (!clusterStatusTracker.isClusterUp()) {
                    this.master.stop("Cluster went down before this master became active");
                }
                if (this.master.isStopped()) {
                    return false;
                }
            }
        }
    }

    public boolean isActiveMaster() {
        try {
            if (ZKUtil.checkExists(this.watcher, this.watcher.masterAddressZNode) >= 0) {
                return true;
            }
        }
        catch (KeeperException ke) {
            LOG.info((Object)("Received an unexpected KeeperException when checking isActiveMaster : " + (Object)((Object)ke)));
        }
        return false;
    }

    public void stop() {
        try {
            ServerName master;
            byte[] bytes = ZKUtil.getDataAndWatch(this.watcher, this.watcher.masterAddressZNode);
            ServerName serverName = master = bytes == null ? null : ServerName.parseVersionedServerName(bytes);
            if (master != null && master.equals(this.sn)) {
                ZKUtil.deleteNode(this.watcher, this.watcher.masterAddressZNode);
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)this.watcher.prefix("Error deleting our own master address node"), (Throwable)e);
        }
    }

    public ServerName getActiveMaster() {
        ServerName sn = null;
        try {
            byte[] bytes = ZKUtil.getDataAndWatch(this.watcher, this.watcher.masterAddressZNode);
            if (bytes == null) {
                String msg = "A master was detected, but went down before its address.";
                LOG.info((Object)msg);
            } else {
                sn = ServerName.parseVersionedServerName(bytes);
            }
        }
        catch (KeeperException e) {
            String msg = "Could not find active master";
            LOG.info((Object)msg);
        }
        return sn;
    }
}

