/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.vba;

import mondrian.olap.InvalidArgumentException;
import mondrian.olap.fun.JavaFunDef;
import mondrian.olap.fun.vba.Vba;

public abstract class Excel {
    @JavaFunDef.FunctionName(value="Acos")
    @JavaFunDef.Signature(value="Acos(number)")
    @JavaFunDef.Description(value="Returns the arccosine, or inverse cosine, of a number. The arccosine is the angle whose cosine is Arg1. The returned angle is given in radians in the range 0 (zero) to pi.")
    public static double acos(double number) {
        return Math.acos(number);
    }

    @JavaFunDef.FunctionName(value="Acosh")
    @JavaFunDef.Signature(value="Acosh(number)")
    @JavaFunDef.Description(value="Returns the inverse hyperbolic cosine of a number. Number must be greater than or equal to 1. The inverse hyperbolic cosine is the value whose hyperbolic cosine is Arg1, so Acosh(Cosh(number)) equals Arg1.")
    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    @JavaFunDef.FunctionName(value="Asin")
    @JavaFunDef.Signature(value="Asin(number)")
    @JavaFunDef.Description(value="Returns the arcsine, or inverse sine, of a number. The arcsine is the angle whose sine is Arg1. The returned angle is given in radians in the range -pi/2 to pi/2.")
    public static double asin(double number) {
        return Math.asin(number);
    }

    @JavaFunDef.FunctionName(value="Asinh")
    @JavaFunDef.Signature(value="Asinh(number)")
    @JavaFunDef.Description(value="Returns the inverse hyperbolic sine of a number. The inverse hyperbolic sine is the value whose hyperbolic sine is Arg1, so Asinh(Sinh(number)) equals Arg1.")
    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(1.0 + x * x));
    }

    @JavaFunDef.FunctionName(value="Atan2")
    @JavaFunDef.Signature(value="Atan2(x, y)")
    @JavaFunDef.Description(value="Returns the arctangent, or inverse tangent, of the specified x- and y-coordinates. The arctangent is the angle from the x-axis to a line containing the origin (0, 0) and a point with coordinates (x_num, y_num). The angle is given in radians between -pi and pi, excluding -pi.")
    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    @JavaFunDef.FunctionName(value="Atanh")
    @JavaFunDef.Signature(value="Atanh(number)")
    @JavaFunDef.Description(value="Returns the inverse hyperbolic tangent of a number. Number must be between -1 and 1 (excluding -1 and 1).")
    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    @JavaFunDef.FunctionName(value="Cosh")
    @JavaFunDef.Description(value="Returns the hyperbolic cosine of a number.")
    public static double cosh(double number) {
        return Math.cosh(number);
    }

    @JavaFunDef.FunctionName(value="Degrees")
    @JavaFunDef.Description(value="Converts radians to degrees.")
    public static double degrees(double number) {
        return number * 180.0 / Math.PI;
    }

    @JavaFunDef.FunctionName(value="Log10")
    @JavaFunDef.Description(value="Returns the base-10 logarithm of a number.")
    public static double log10(double number) {
        return Math.log10(number);
    }

    @JavaFunDef.FunctionName(value="Mod")
    @JavaFunDef.Signature(value="Mod(n, d)")
    @JavaFunDef.Description(value="Returns the remainder of dividing n by d.")
    public static double mod(Object first, Object second) {
        if (!(first instanceof Number)) {
            throw new InvalidArgumentException("Invalid parameter. first parameter " + first + " of Mod function must be of type number");
        }
        double iFirst = ((Number)first).doubleValue();
        if (!(second instanceof Number)) {
            throw new InvalidArgumentException("Invalid parameter. second parameter " + second + " of Mod function must be of type number");
        }
        double iSecond = ((Number)second).doubleValue();
        if (iSecond == 0.0) {
            throw new ArithmeticException("/ by zero");
        }
        return iFirst - iSecond * (double)Vba.intNative(iFirst / iSecond);
    }

    @JavaFunDef.FunctionName(value="Pi")
    @JavaFunDef.Description(value="Returns the number 3.14159265358979, the mathematical constant pi, accurate to 15 digits.")
    public static double pi() {
        return Math.PI;
    }

    @JavaFunDef.FunctionName(value="Power")
    @JavaFunDef.Description(value="Returns the result of a number raised to a power.")
    public static double power(double x, double y) {
        return Math.pow(x, y);
    }

    @JavaFunDef.FunctionName(value="Radians")
    @JavaFunDef.Description(value="Converts degrees to radians.")
    public static double radians(double number) {
        return number / 180.0 * Math.PI;
    }

    @JavaFunDef.FunctionName(value="Sinh")
    @JavaFunDef.Description(value="Returns the hyperbolic sine of a number.")
    public static double sinh(double number) {
        return Math.sinh(number);
    }

    @JavaFunDef.FunctionName(value="SqrtPi")
    @JavaFunDef.Description(value="Returns the square root of (number * pi).")
    public static double sqrtPi(double number) {
        return Math.sqrt(number * Math.PI);
    }

    @JavaFunDef.FunctionName(value="Tanh")
    @JavaFunDef.Description(value="Returns the hyperbolic tangent of a number.")
    public static double tanh(double number) {
        return Math.tanh(number);
    }
}

