/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Connection;
import mondrian.olap.Evaluator;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.olap.type.ScalarType;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import org.olap4j.AllocationPolicy;
import org.olap4j.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScenarioImpl
implements Scenario {
    private final int id;
    private final List<WritebackCell> writebackCells = new ArrayList<WritebackCell>();
    private RolapMember member;
    private static int nextId;

    public ScenarioImpl() {
        this.id = nextId++;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof ScenarioImpl && this.id == ((ScenarioImpl)obj).id;
    }

    public String toString() {
        return "scenario #" + this.id;
    }

    public void setCellValue(Connection connection, List<RolapMember> members, double newValue, double currentValue, AllocationPolicy allocationPolicy, Object[] allocationArgs) {
        Util.discard((Object)connection);
        assert (allocationPolicy != null);
        assert (allocationArgs != null);
        switch (allocationPolicy) {
            case EQUAL_ALLOCATION: 
            case EQUAL_INCREMENT: {
                if (allocationArgs.length == 0) break;
                throw Util.newError("Allocation policy " + allocationPolicy + " takes 0 arguments; " + allocationArgs.length + " were supplied");
            }
            default: {
                throw Util.newError("Allocation policy " + allocationPolicy + " is not supported");
            }
        }
        RolapStoredMeasure measure = (RolapStoredMeasure)((Object)members.get(0));
        RolapCube baseCube = measure.getCube();
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        int starColumnCount = starMeasure.getStar().getColumnCount();
        BitKey constrainedColumnsBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Object[] keyValues = new Object[starColumnCount];
        block3: for (int i = 1; i < members.size(); ++i) {
            Member member = members.get(i);
            for (RolapCubeMember m = (RolapCubeMember)member; m != null && !m.isAll(); m = m.getParentMember()) {
                RolapCubeLevel level = m.getLevel();
                RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
                if (column != null) {
                    int bitPos = column.getBitPosition();
                    keyValues[bitPos] = m.getKey();
                    constrainedColumnsBitKey.set(bitPos);
                }
                if (level.areMembersUnique()) continue block3;
            }
        }
        Object[] compactKeyValues = new Object[constrainedColumnsBitKey.cardinality()];
        int k = 0;
        for (int bitPos : constrainedColumnsBitKey) {
            compactKeyValues[k++] = keyValues[bitPos];
        }
        this.writebackCells.add(new WritebackCell(baseCube, new ArrayList<RolapMember>(members), constrainedColumnsBitKey, compactKeyValues, newValue, currentValue, allocationPolicy));
    }

    public String getId() {
        return Integer.toString(this.id);
    }

    static Scenario forMember(RolapMember member) {
        if (ScenarioImpl.isScenario(member.getHierarchy())) {
            Formula formula = ((RolapCalculatedMember)member).getFormula();
            ResolvedFunCall resolvedFunCall = (ResolvedFunCall)formula.getExpression();
            Calc calc = resolvedFunCall.getFunDef().compileCall(null, null);
            return ((ScenarioCalc)calc).getScenario();
        }
        return null;
    }

    void register(RolapSchema schema) {
        for (RolapCube cube : schema.getCubeList()) {
            for (RolapHierarchy hierarchy : cube.getHierarchies()) {
                if (!ScenarioImpl.isScenario(hierarchy)) continue;
                this.member = cube.createCalculatedMember(hierarchy, this.getId() + "", new ScenarioCalc(this));
                assert (this.member != null);
            }
        }
    }

    public static boolean isScenario(Hierarchy hierarchy) {
        return hierarchy.getName().equals("Scenario");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double evaluateAtomicCellCount(RolapEvaluator evaluator) {
        int savepoint = evaluator.savepoint();
        try {
            evaluator.setContext(evaluator.getCube().getAtomicCellCountMeasure());
            Object o = evaluator.evaluateCurrent();
            double d = ((Number)o).doubleValue();
            return d;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    private static double computeAtomicCellCount(RolapCube cube, List<RolapMember> memberList) {
        Query query;
        StringBuilder buf = new StringBuilder();
        buf.append("select from ");
        buf.append(cube.getUniqueName());
        int k = 0;
        for (RolapMember member : memberList) {
            if (member.isMeasure()) {
                member = cube.factCountMeasure;
                assert (member != null) : "fact count measure is required for writeback cubes";
            }
            if (member.equals(member.getHierarchy().getDefaultMember())) continue;
            if (k++ > 0) {
                buf.append(", ");
            } else {
                buf.append(" where (");
            }
            buf.append(member.getUniqueName());
        }
        if (k > 0) {
            buf.append(")");
        }
        String mdx = buf.toString();
        RolapConnection connection = cube.getSchema().getInternalConnection();
        Result result = connection.execute(query = connection.parseQuery(mdx));
        Object o = result.getCell(new int[0]).getValue();
        return o instanceof Number ? ((Number)o).doubleValue() : 0.0;
    }

    public RolapMember getMember() {
        return this.member;
    }

    private static class ScenarioCalc
    extends GenericCalc {
        private final ScenarioImpl scenario;

        public ScenarioCalc(ScenarioImpl scenario) {
            super(new DummyExp(new ScalarType()));
            this.scenario = scenario;
        }

        private Scenario getScenario() {
            return this.scenario;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evaluate(Evaluator evaluator) {
            Member defaultMember = this.scenario.member.getHierarchy().getDefaultMember();
            int savepoint = evaluator.savepoint();
            try {
                Object object;
                evaluator.setContext(defaultMember);
                Object o = evaluator.evaluateCurrent();
                double d = o instanceof Number ? ((Number)o).doubleValue() : 0.0;
                int changeCount = 0;
                block14: for (WritebackCell writebackCell : this.scenario.writebackCells) {
                    CellRelation relation = writebackCell.getRelationTo(evaluator.getMembers());
                    switch (relation) {
                        case ABOVE: {
                            double atomicCellCount = ScenarioImpl.evaluateAtomicCellCount((RolapEvaluator)evaluator);
                            if (atomicCellCount == 0.0) {
                                atomicCellCount = 1.0;
                            }
                            switch (writebackCell.allocationPolicy) {
                                case EQUAL_ALLOCATION: {
                                    d = writebackCell.newValue * atomicCellCount / writebackCell.atomicCellCount;
                                    break;
                                }
                                case EQUAL_INCREMENT: {
                                    d += writebackCell.getOffset() * atomicCellCount / writebackCell.atomicCellCount;
                                    break;
                                }
                                default: {
                                    throw Util.unexpected((Enum)writebackCell.allocationPolicy);
                                }
                            }
                            ++changeCount;
                            continue block14;
                        }
                        case EQUAL: {
                            d = writebackCell.newValue;
                            ++changeCount;
                            continue block14;
                        }
                        case BELOW: {
                            d += writebackCell.getOffset();
                            ++changeCount;
                            continue block14;
                        }
                        case NONE: {
                            continue block14;
                        }
                    }
                    throw Util.unexpected(relation);
                }
                if (changeCount == 0) {
                    object = o;
                    return object;
                }
                object = d;
                return object;
            }
            finally {
                evaluator.restore(savepoint);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CellRelation {
        ABOVE,
        EQUAL,
        BELOW,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WritebackCell {
        private final double newValue;
        private final double currentValue;
        private final AllocationPolicy allocationPolicy;
        private Member[] membersByOrdinal;
        private final double atomicCellCount;

        WritebackCell(RolapCube cube, List<RolapMember> members, BitKey constrainedColumnsBitKey, Object[] keyValues, double newValue, double currentValue, AllocationPolicy allocationPolicy) {
            assert (keyValues.length == constrainedColumnsBitKey.cardinality());
            Util.discard((Object)cube);
            Util.discard((Object)constrainedColumnsBitKey);
            Util.discard((Object)keyValues);
            this.newValue = newValue;
            this.currentValue = currentValue;
            this.allocationPolicy = allocationPolicy;
            this.atomicCellCount = ScenarioImpl.computeAtomicCellCount(cube, members);
            List<RolapHierarchy> hierarchyList = cube.getHierarchies();
            this.membersByOrdinal = new Member[hierarchyList.size()];
            for (int i = 0; i < this.membersByOrdinal.length; ++i) {
                this.membersByOrdinal[i] = hierarchyList.get(i).getDefaultMember();
            }
            for (RolapMember member : members) {
                RolapHierarchy hierarchy = member.getHierarchy();
                if (ScenarioImpl.isScenario(hierarchy)) assert (member.isAll());
                int ordinal = hierarchy.getOrdinalInCube();
                this.membersByOrdinal[ordinal] = member;
            }
        }

        public double getOffset() {
            return this.newValue - this.currentValue;
        }

        CellRelation getRelationTo(Member[] members) {
            int aboveCount = 0;
            int belowCount = 0;
            for (int i = 0; i < members.length; ++i) {
                Member thatMember = members[i];
                Member thisMember = this.membersByOrdinal[i];
                if (thatMember.isChildOrEqualTo(thisMember)) {
                    if (thatMember.equals(thisMember)) continue;
                    ++aboveCount;
                    if (belowCount <= 0) continue;
                    return CellRelation.NONE;
                }
                if (thisMember.isChildOrEqualTo(thatMember)) {
                    ++belowCount;
                    if (aboveCount <= 0) continue;
                    return CellRelation.NONE;
                }
                return CellRelation.NONE;
            }
            assert (aboveCount == 0 || belowCount == 0);
            if (aboveCount > 0) {
                return CellRelation.ABOVE;
            }
            if (belowCount > 0) {
                return CellRelation.BELOW;
            }
            return CellRelation.EQUAL;
        }
    }
}

