/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import mondrian.calc.TupleIterable;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.util.FilteredIterableList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintUtils {
    private static final Logger LOG = Logger.getLogger(SqlConstraintUtils.class);

    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQuery sqlQuery, AggStar aggStar, Evaluator evaluator, RolapCube baseCube, boolean restrictMemberTypes) {
        CellRequest request;
        Member[] members = evaluator.getNonAllMembers();
        members = SqlConstraintUtils.expandSupportedCalculatedMembers(members, evaluator);
        members = SqlConstraintUtils.getUniqueOrdinalMembers(members);
        if (baseCube == null && evaluator instanceof RolapEvaluator) {
            baseCube = ((RolapEvaluator)evaluator).getCube();
        }
        if (restrictMemberTypes) {
            if (SqlConstraintUtils.containsCalculatedMember(members, true)) {
                throw Util.newInternal("can not restrict SQL to calculated Members");
            }
        } else {
            members = SqlConstraintUtils.removeCalculatedAndDefaultMembers(members);
        }
        if ((request = RolapAggregationManager.makeRequest(members)) == null) {
            if (restrictMemberTypes) {
                throw Util.newInternal("CellRequest is null - why?");
            }
            return;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] values = request.getSingleValues();
        Map<MondrianDef.Expression, Set<RolapMember>> mapOfSlicerMembers = null;
        HashMap<MondrianDef.Expression, Boolean> done = new HashMap<MondrianDef.Expression, Boolean>();
        for (int i = 0; i < columns.length; ++i) {
            MondrianDef.Expression keyForSlicerMap;
            String expr;
            RolapStar.Column column = columns[i];
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                AggStar.Table table = aggColumn.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = aggColumn.generateExprString(sqlQuery);
            } else {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = column.generateExprString(sqlQuery);
            }
            String value = String.valueOf(values[i]);
            if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(value) || value.equalsIgnoreCase(RolapUtil.sqlNullValue.toString())) {
                sqlQuery.addWhere(expr, " is ", "null");
                continue;
            }
            if (column.getDatatype().isNumeric()) {
                Double.valueOf(value);
            }
            if (mapOfSlicerMembers == null) {
                mapOfSlicerMembers = SqlConstraintUtils.getSlicerMemberMap(evaluator);
            }
            if (mapOfSlicerMembers.containsKey(keyForSlicerMap = column.getExpression())) {
                if (done.containsKey(keyForSlicerMap)) continue;
                Set<RolapMember> slicerMembersSet = mapOfSlicerMembers.get(keyForSlicerMap);
                ArrayList<RolapMember> slicerMembers = new ArrayList<RolapMember>(slicerMembersSet);
                ArrayList<RolapMember> allMembers = new ArrayList<RolapMember>();
                for (RolapMember slicerMember : slicerMembers) {
                    if (!slicerMember.isAll()) continue;
                    allMembers.add(slicerMember);
                }
                if (allMembers.size() > 0) {
                    slicerMembers.removeAll(allMembers);
                }
                if (slicerMembers.size() > 0) {
                    int levelIndex = ((RolapMember)slicerMembers.get(0)).getHierarchy().getLevels().length;
                    RolapLevel levelForWhere = (RolapLevel)((RolapMember)slicerMembers.get(0)).getHierarchy().getLevels()[levelIndex - 1];
                    String where = SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, slicerMembers, levelForWhere, restrictMemberTypes, false, false);
                    if (!where.equals("")) {
                        sqlQuery.addWhere(where);
                    }
                } else {
                    StringBuilder buf = new StringBuilder();
                    sqlQuery.getDialect().quote(buf, value, column.getDatatype());
                    sqlQuery.addWhere(expr, " = ", buf.toString());
                }
                done.put(keyForSlicerMap, Boolean.TRUE);
                continue;
            }
            StringBuilder buf = new StringBuilder();
            sqlQuery.getDialect().quote(buf, value, column.getDatatype());
            sqlQuery.addWhere(expr, " = ", buf.toString());
        }
        SqlConstraintUtils.addRoleAccessConstraints(sqlQuery, aggStar, restrictMemberTypes, baseCube, evaluator);
    }

    public static Map<Level, List<RolapMember>> getRoleConstraintMembers(SchemaReader schemaReader, Member[] members) {
        LinkedHashMap<Level, List<RolapMember>> roleMembers = new LinkedHashMap<Level, List<RolapMember>>();
        Role role = schemaReader.getRole();
        block0: for (Member member : members) {
            if (!(member instanceof RolapHierarchy.LimitedRollupMember) && !(member instanceof RestrictedMemberReader.MultiCardinalityDefaultMember)) continue;
            List<Level> hierarchyLevels = schemaReader.getHierarchyLevels(member.getHierarchy());
            for (Level affectedLevel : hierarchyLevels) {
                ArrayList<RolapMember> slicerMembers = new ArrayList<RolapMember>();
                boolean hasCustom = false;
                List<Member> availableMembers = schemaReader.getLevelMembers(affectedLevel, false);
                for (Member availableMember : availableMembers) {
                    if (!availableMember.isAll()) {
                        slicerMembers.add((RolapMember)availableMember);
                    }
                    hasCustom |= role.getAccess(availableMember) == Access.CUSTOM;
                }
                if (!slicerMembers.isEmpty()) {
                    roleMembers.put(affectedLevel, slicerMembers);
                }
                if (hasCustom) continue;
                continue block0;
            }
        }
        return roleMembers;
    }

    private static void addRoleAccessConstraints(SqlQuery sqlQuery, AggStar aggStar, boolean restrictMemberTypes, RolapCube baseCube, Evaluator evaluator) {
        Map<Level, List<RolapMember>> roleMembers = SqlConstraintUtils.getRoleConstraintMembers(evaluator.getSchemaReader(), evaluator.getMembers());
        for (Map.Entry<Level, List<RolapMember>> entry : roleMembers.entrySet()) {
            String where = SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, entry.getValue(), (RolapCubeLevel)entry.getKey(), restrictMemberTypes, false, true);
            if (where.length() <= 1) continue;
            SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, baseCube, aggStar, evaluator, (RolapCubeLevel)entry.getKey());
            sqlQuery.addWhere(where);
        }
    }

    private static Map<MondrianDef.Expression, Set<RolapMember>> getSlicerMemberMap(Evaluator evaluator) {
        Member[] expandedSlicers;
        HashMap<MondrianDef.Expression, Set<RolapMember>> mapOfSlicerMembers = new HashMap<MondrianDef.Expression, Set<RolapMember>>();
        if (evaluator.isEvalAxes() && SqlConstraintUtils.hasMultiPositionSlicer(expandedSlicers = SqlConstraintUtils.expandSupportedCalculatedMembers(((RolapEvaluator)evaluator).getSlicerMembers(), evaluator.push()))) {
            for (Member slicerMember : expandedSlicers) {
                if (slicerMember.isMeasure()) continue;
                SqlConstraintUtils.addSlicedMemberToMap(mapOfSlicerMembers, slicerMember);
            }
        }
        return mapOfSlicerMembers;
    }

    private static void addSlicedMemberToMap(Map<MondrianDef.Expression, Set<RolapMember>> mapOfSlicerMembers, Member slicerMember) {
        if (slicerMember == null || slicerMember.isAll() || slicerMember.isNull()) {
            return;
        }
        assert (slicerMember instanceof RolapMember);
        MondrianDef.Expression expression = ((RolapLevel)slicerMember.getLevel()).getKeyExp();
        if (!mapOfSlicerMembers.containsKey(expression)) {
            mapOfSlicerMembers.put(expression, new LinkedHashSet());
        }
        mapOfSlicerMembers.get(expression).add((RolapMember)slicerMember);
        SqlConstraintUtils.addSlicedMemberToMap(mapOfSlicerMembers, slicerMember.getParentMember());
    }

    private static boolean hasMultiPositionSlicer(Member[] slicerMembers) {
        HashMap<Hierarchy, Member> mapOfSlicerMembers = new HashMap<Hierarchy, Member>();
        for (Member slicerMember : slicerMembers) {
            Hierarchy hierarchy = slicerMember.getHierarchy();
            if (mapOfSlicerMembers.containsKey(hierarchy)) {
                return true;
            }
            mapOfSlicerMembers.put(hierarchy, slicerMember);
        }
        return false;
    }

    public static Member[] expandSupportedCalculatedMembers(List<Member> listOfMembers, Evaluator evaluator) {
        return SqlConstraintUtils.expandSupportedCalculatedMembers(listOfMembers.toArray(new Member[listOfMembers.size()]), evaluator);
    }

    public static Member[] expandSupportedCalculatedMembers(Member[] members, Evaluator evaluator) {
        ArrayList<Member> listOfMembers = new ArrayList<Member>();
        for (Member member : members) {
            if (member.isCalculated() && SqlConstraintUtils.isSupportedCalculatedMember(member)) {
                listOfMembers.addAll(SqlConstraintUtils.expandExpressions(member, null, evaluator));
                continue;
            }
            listOfMembers.add(member);
        }
        members = listOfMembers.toArray(new Member[listOfMembers.size()]);
        return members;
    }

    public static List<Member> expandExpressions(Member member, Exp expression, Evaluator evaluator) {
        ArrayList<Member> listOfMembers = new ArrayList<Member>();
        if (expression == null) {
            expression = member.getExpression();
        }
        if (expression instanceof ResolvedFunCall) {
            ResolvedFunCall fun = (ResolvedFunCall)expression;
            if (fun.getFunDef() instanceof ParenthesesFunDef) {
                assert (fun.getArgCount() == 1);
                listOfMembers.addAll(SqlConstraintUtils.expandExpressions(member, fun.getArg(0), evaluator));
            } else if (fun.getFunName().equals("+")) {
                Exp[] expressions;
                for (Exp innerExp : expressions = fun.getArgs()) {
                    listOfMembers.addAll(SqlConstraintUtils.expandExpressions(member, innerExp, evaluator));
                }
            } else {
                Iterator<Member> evaluatedSet = SqlConstraintUtils.getSetFromCalculatedMember(evaluator, member);
                while (evaluatedSet.hasNext()) {
                    listOfMembers.add(evaluatedSet.next());
                }
            }
        } else if (expression instanceof MemberExpr) {
            listOfMembers.add(((MemberExpr)expression).getMember());
        } else {
            listOfMembers.add(member);
        }
        return listOfMembers;
    }

    public static boolean isSupportedCalculatedMember(Member member) {
        return SqlConstraintUtils.isSupportedExpressionForCalculatedMember(member.getExpression());
    }

    public static boolean isSupportedExpressionForCalculatedMember(Exp expression) {
        if (expression instanceof ResolvedFunCall) {
            ResolvedFunCall fun = (ResolvedFunCall)expression;
            if (fun.getFunDef() instanceof AggregateFunDef) {
                return true;
            }
            if (fun.getFunDef() instanceof ParenthesesFunDef) {
                if (fun.getArgs().length == 1) {
                    for (Exp argsExp : fun.getArgs()) {
                        if (SqlConstraintUtils.isSupportedExpressionForCalculatedMember(argsExp)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (fun.getFunDef().getName().equals("+")) {
                for (Exp argsExp : fun.getArgs()) {
                    if (SqlConstraintUtils.isSupportedExpressionForCalculatedMember(argsExp)) continue;
                    return false;
                }
                return true;
            }
        }
        return expression instanceof MemberExpr;
    }

    public static Iterator<Member> getSetFromCalculatedMember(Evaluator evaluator, Member member) {
        assert (member.getExpression() instanceof ResolvedFunCall);
        ResolvedFunCall fun = (ResolvedFunCall)member.getExpression();
        Exp exp = fun.getArg(0);
        TupleIterable tupleIterable = evaluator.getSetEvaluator(exp, true).evaluateTupleIterable();
        Iterable<Member> iterable = tupleIterable.slice(0);
        return iterable.iterator();
    }

    protected static Member[] getUniqueOrdinalMembers(Member[] members) {
        ArrayList<Integer> currentOrdinals = new ArrayList<Integer>();
        ArrayList<Member> uniqueMembers = new ArrayList<Member>();
        for (Member member : members) {
            RolapMemberBase m = (RolapMemberBase)member;
            int ordinal = m.getHierarchyOrdinal();
            if (currentOrdinals.contains(ordinal)) continue;
            uniqueMembers.add(member);
            currentOrdinals.add(ordinal);
        }
        return uniqueMembers.toArray(new Member[uniqueMembers.size()]);
    }

    protected static Member[] expandMultiPositionSlicerMembers(Member[] members, Evaluator evaluator) {
        List<Member> slicerMembers = null;
        if (evaluator instanceof RolapEvaluator) {
            slicerMembers = ((RolapEvaluator)evaluator).getSlicerMembers();
        }
        if (slicerMembers != null) {
            HashMap mapOfSlicerMembers = new HashMap();
            for (Member slicerMember : slicerMembers) {
                Hierarchy hierarchy = slicerMember.getHierarchy();
                if (!mapOfSlicerMembers.containsKey(hierarchy)) {
                    mapOfSlicerMembers.put(hierarchy, new HashSet());
                }
                ((Set)mapOfSlicerMembers.get(hierarchy)).add(slicerMember);
            }
            ArrayList<Member> listOfMembers = new ArrayList<Member>();
            for (Member member : members) {
                Hierarchy hierarchy = member.getHierarchy();
                if (!mapOfSlicerMembers.containsKey(hierarchy) || ((Set)mapOfSlicerMembers.get(hierarchy)).size() < 2) {
                    listOfMembers.add(member);
                    continue;
                }
                listOfMembers.addAll((Collection)mapOfSlicerMembers.get(hierarchy));
            }
            members = listOfMembers.toArray(new Member[listOfMembers.size()]);
        }
        return members;
    }

    private static Member[] removeCalculatedAndDefaultMembers(Member[] members) {
        ArrayList<Member> memberList = new ArrayList<Member>(members.length);
        for (int i = 0; i < members.length; ++i) {
            Member member = members[i];
            if (member.isCalculated() && !member.isParentChildLeaf() || i > 0 && member.getHierarchy().getDefaultMember().equals(member)) continue;
            memberList.add(member);
        }
        return memberList.toArray(new Member[memberList.size()]);
    }

    static List<Member> removeCalculatedMembers(List<Member> members) {
        return new FilteredIterableList<Member>(members, new FilteredIterableList.Filter<Member>(){

            @Override
            public boolean accept(Member m) {
                return !m.isCalculated() || m.isParentChildLeaf();
            }
        });
    }

    public static boolean containsCalculatedMember(Member[] members) {
        return SqlConstraintUtils.containsCalculatedMember(members, false);
    }

    public static boolean containsCalculatedMember(Member[] members, boolean allowExpandableMembers) {
        for (Member member : members) {
            if (!member.isCalculated()) continue;
            if (allowExpandableMembers) {
                if (SqlConstraintUtils.isSupportedCalculatedMember(member)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, Evaluator e, RolapCubeLevel level) {
        RolapStar.Column starColumn = level.getBaseStarKeyColumn(baseCube);
        if (aggStar != null) {
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            AggStar.Table table = aggColumn.getTable();
            table.addToFrom(sqlQuery, false, true);
        } else {
            RolapStar.Table table = starColumn.getTable();
            assert (table != null);
            table.addToFrom(sqlQuery, false, true);
        }
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapMember parent, boolean restrictMemberTypes) {
        List<RolapMember> list = Collections.singletonList(parent);
        boolean exclude = false;
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, list, restrictMemberTypes, false, exclude);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, boolean restrictMemberTypes, boolean crossJoin, boolean exclude) {
        RolapMember firstUniqueParent;
        if (members.size() == 0) {
            String predicate = "(1 = 0)";
            if (exclude) {
                predicate = "(1 = 1)";
            }
            sqlQuery.addWhere(predicate);
            return;
        }
        RolapMember member = members.get(0);
        RolapLevel memberLevel = member.getLevel();
        RolapLevel firstUniqueParentLevel = null;
        for (firstUniqueParent = member; firstUniqueParent != null && !firstUniqueParent.getLevel().isUnique(); firstUniqueParent = firstUniqueParent.getParentMember()) {
        }
        if (firstUniqueParent != null) {
            firstUniqueParentLevel = firstUniqueParent.getLevel();
        }
        String condition = "(";
        if (crossJoin && !memberLevel.isUnique() && !SqlConstraintUtils.membersAreCrossProduct(members)) {
            assert (member.getParentMember() != null);
            condition = condition + SqlConstraintUtils.constrainMultiLevelMembers(sqlQuery, baseCube, aggStar, members, firstUniqueParentLevel, restrictMemberTypes, exclude);
        } else {
            condition = condition + SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, members, firstUniqueParentLevel, restrictMemberTypes, exclude, true);
        }
        if (condition.length() > 1) {
            condition = condition + ")";
            sqlQuery.addWhere(condition);
        }
    }

    private static StarColumnPredicate getColumnPredicates(RolapStar.Column column, Collection<RolapMember> members) {
        switch (members.size()) {
            case 0: {
                return new LiteralStarPredicate(column, false);
            }
            case 1: {
                return new MemberColumnPredicate(column, members.iterator().next());
            }
        }
        ArrayList<StarColumnPredicate> predicateList = new ArrayList<StarColumnPredicate>();
        for (RolapMember member : members) {
            predicateList.add(new MemberColumnPredicate(column, member));
        }
        return new ListColumnPredicate(column, predicateList);
    }

    private static LinkedHashSet<RolapMember> getUniqueParentMembers(Collection<RolapMember> members) {
        LinkedHashSet<RolapMember> set = new LinkedHashSet<RolapMember>();
        for (RolapMember m : members) {
            if ((m = m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    private static String constrainMultiLevelMembers(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, boolean exclude) {
        LinkedHashMap<RolapMember, List<RolapMember>> parentChildrenMap = new LinkedHashMap<RolapMember, List<RolapMember>>();
        StringBuilder condition = new StringBuilder();
        StringBuilder condition1 = new StringBuilder();
        if (exclude) {
            condition.append("not (");
        }
        if (sqlQuery.getDialect().supportsMultiValueInExpr()) {
            condition1.append(SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, baseCube, aggStar, members, fromLevel, restrictMemberTypes, parentChildrenMap));
            if (parentChildrenMap.isEmpty()) {
                condition.append(condition1.toString());
                if (exclude) {
                    condition.append(")");
                    condition.append(" or ");
                    condition.append(SqlConstraintUtils.generateMultiValueIsNullExprs(sqlQuery, baseCube, members.get(0), fromLevel, aggStar));
                }
                return condition.toString();
            }
        } else {
            for (RolapMember m : members) {
                if (m.isCalculated()) {
                    if (!restrictMemberTypes) continue;
                    throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                }
                RolapMember p = m.getParentMember();
                ArrayList<RolapMember> childrenList = (ArrayList<RolapMember>)parentChildrenMap.get(p);
                if (childrenList == null) {
                    childrenList = new ArrayList<RolapMember>();
                    parentChildrenMap.put(p, childrenList);
                }
                childrenList.add(m);
            }
        }
        boolean firstParent = true;
        StringBuilder condition2 = new StringBuilder();
        if (condition1.length() > 0) {
            firstParent = false;
            condition.append(condition1.toString());
            condition.append(" or ");
        }
        RolapLevel memberLevel = members.get(0).getLevel();
        for (RolapMember p : parentChildrenMap.keySet()) {
            assert (p != null);
            if (condition2.toString().length() > 0) {
                condition2.append(" or ");
            }
            condition2.append("(");
            int levelCount = 0;
            for (RolapMember gp = p; gp != null; gp = gp.getParentMember()) {
                if (gp.isAll()) continue;
                RolapLevel level = gp.getLevel();
                if (firstParent) {
                    RolapHierarchy hierarchy = level.getHierarchy();
                    RolapStar.Column column = null;
                    if (level instanceof RolapCubeLevel) {
                        column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                    }
                    if (column != null) {
                        if (aggStar != null) {
                            int bitPos = column.getBitPosition();
                            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                            AggStar.Table table = aggColumn.getTable();
                            table.addToFrom(sqlQuery, false, true);
                        } else {
                            RolapStar.Table targetTable = column.getTable();
                            hierarchy.addToFrom(sqlQuery, targetTable);
                        }
                    } else {
                        assert (aggStar == null);
                        hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                    }
                }
                if (levelCount > 0) {
                    condition2.append(" and ");
                }
                ++levelCount;
                condition2.append(SqlConstraintUtils.constrainLevel(level, sqlQuery, baseCube, aggStar, SqlConstraintUtils.getColumnValue(level.nameExp != null ? gp.getName() : gp.getKey(), sqlQuery.getDialect(), level.getDatatype()), false));
                if (gp.getLevel() == fromLevel) break;
            }
            firstParent = false;
            List children = (List)parentChildrenMap.get(p);
            if (!children.isEmpty()) {
                HashMap<RolapMember, List<RolapMember>> tmpParentChildrenMap = new HashMap<RolapMember, List<RolapMember>>();
                if (levelCount > 0) {
                    condition2.append(" and ");
                }
                RolapLevel childrenLevel = (RolapLevel)p.getLevel().getChildLevel();
                if (sqlQuery.getDialect().supportsMultiValueInExpr() && childrenLevel != memberLevel) {
                    condition2.append(SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, baseCube, aggStar, children, childrenLevel, restrictMemberTypes, tmpParentChildrenMap));
                    assert (tmpParentChildrenMap.isEmpty());
                } else {
                    assert (childrenLevel == memberLevel);
                    condition2.append(SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, aggStar, children, childrenLevel, restrictMemberTypes, false, true));
                }
            }
            condition2.append(")");
        }
        condition.append(condition2.toString());
        if (exclude) {
            condition.append(") or (");
            condition.append(SqlConstraintUtils.generateMultiValueIsNullExprs(sqlQuery, baseCube, members.get(0), fromLevel, aggStar));
            condition.append(" and not(");
            condition.append(condition2.toString());
            condition.append("))");
        }
        return condition.toString();
    }

    private static boolean membersAreCrossProduct(List<RolapMember> members) {
        int crossProdSize = SqlConstraintUtils.getNumUniqueMemberKeys(members);
        LinkedHashSet<RolapMember> parents = SqlConstraintUtils.getUniqueParentMembers(members);
        while (!parents.isEmpty()) {
            crossProdSize *= parents.size();
            parents = SqlConstraintUtils.getUniqueParentMembers(parents);
        }
        return crossProdSize == members.size();
    }

    private static int getNumUniqueMemberKeys(List<RolapMember> members) {
        HashSet<Object> set = new HashSet<Object>();
        for (RolapMember m : members) {
            set.add(m.getKey());
        }
        return set.size();
    }

    private static String getColumnValue(Object key, Dialect dialect, Dialect.Datatype datatype) {
        if (key != RolapUtil.sqlNullValue) {
            return key.toString();
        }
        return RolapUtil.mdxNullLiteral();
    }

    public static String constrainLevel(RolapLevel level, SqlQuery query, RolapCube baseCube, AggStar aggStar, String columnValue, boolean caseSensitive) {
        String constraint;
        String columnString;
        Dialect.Datatype datatype;
        RolapStar.Column column = null;
        if (level instanceof RolapCubeLevel) {
            column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
        }
        if (column != null) {
            if (column.getNameColumn() == null) {
                datatype = level.getDatatype();
            } else {
                column = column.getNameColumn();
                datatype = Dialect.Datatype.String;
            }
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                columnString = aggColumn.generateExprString(query);
            } else {
                columnString = column.generateExprString(query);
            }
        } else {
            assert (aggStar == null);
            MondrianDef.Expression exp = level.getNameExp();
            if (exp == null) {
                exp = level.getKeyExp();
                datatype = level.getDatatype();
            } else {
                datatype = Dialect.Datatype.String;
            }
            columnString = exp.getExpression(query);
        }
        if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(columnValue)) {
            constraint = columnString + " is " + "null";
        } else {
            if (datatype.isNumeric()) {
                Double.valueOf(columnValue);
            }
            StringBuilder buf = new StringBuilder();
            query.getDialect().quote(buf, columnValue, datatype);
            String value = buf.toString();
            if (caseSensitive && datatype == Dialect.Datatype.String && !MondrianProperties.instance().CaseSensitive.get()) {
                columnString = query.getDialect().toUpper(columnString);
                value = query.getDialect().toUpper(value);
            }
            constraint = columnString + " = " + value;
        }
        return constraint;
    }

    public static String constrainLevel2(SqlQuery query, MondrianDef.Expression exp, Dialect.Datatype datatype, Comparable columnValue) {
        String columnString = exp.getExpression(query);
        if (columnValue == RolapUtil.sqlNullValue) {
            return columnString + " is " + "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(columnString);
        buf.append(" = ");
        query.getDialect().quote(buf, columnValue, datatype);
        return buf.toString();
    }

    private static String generateMultiValueInExpr(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, Map<RolapMember, List<RolapMember>> parentWithNullToChildrenMap) {
        StringBuilder columnBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        StringBuilder memberBuf = new StringBuilder();
        columnBuf.append("(");
        int ordinalInMultiple = 0;
        for (RolapMember m = members.get(0); m != null; m = m.getParentMember()) {
            if (m.isAll()) continue;
            String columnString = SqlConstraintUtils.getColumnString(sqlQuery, aggStar, m.getLevel(), baseCube);
            if (ordinalInMultiple++ > 0) {
                columnBuf.append(", ");
            }
            columnBuf.append(columnString);
            if (m.getLevel() == fromLevel) break;
        }
        columnBuf.append(")");
        valueBuf.append("(");
        int memberOrdinal = 0;
        for (RolapMember m : members) {
            if (m.isCalculated()) {
                if (!restrictMemberTypes) continue;
                throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
            }
            ordinalInMultiple = 0;
            memberBuf.setLength(0);
            memberBuf.append("(");
            boolean containsNull = false;
            for (RolapMember p = m; p != null; p = p.getParentMember()) {
                if (p.isAll()) continue;
                RolapLevel level = p.getLevel();
                String value = SqlConstraintUtils.getColumnValue(p.getKey(), sqlQuery.getDialect(), level.getDatatype());
                if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(value)) {
                    List<RolapMember> childrenList = parentWithNullToChildrenMap.get(p);
                    if (childrenList == null) {
                        childrenList = new ArrayList<RolapMember>();
                        parentWithNullToChildrenMap.put(p, childrenList);
                    }
                    if (m != p) {
                        childrenList.add(m);
                    }
                    containsNull = true;
                    break;
                }
                if (ordinalInMultiple++ > 0) {
                    memberBuf.append(", ");
                }
                sqlQuery.getDialect().quote(memberBuf, value, level.getDatatype());
                if (p.getLevel() == fromLevel) break;
            }
            if (containsNull) continue;
            memberBuf.append(")");
            if (memberOrdinal++ > 0) {
                valueBuf.append(", ");
            }
            valueBuf.append((CharSequence)memberBuf);
        }
        StringBuilder condition = new StringBuilder();
        if (memberOrdinal > 0) {
            condition.append((CharSequence)columnBuf);
            condition.append(" in ");
            condition.append((CharSequence)valueBuf);
            condition.append(")");
        }
        return condition.toString();
    }

    private static String getColumnString(SqlQuery sqlQuery, AggStar aggStar, RolapLevel level, RolapCube baseCube) {
        String columnString;
        RolapStar.Column column = null;
        if (level instanceof RolapCubeLevel) {
            column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
        }
        RolapHierarchy hierarchy = level.getHierarchy();
        if (column != null) {
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                AggStar.Table table = aggColumn.getTable();
                table.addToFrom(sqlQuery, false, true);
                columnString = aggColumn.generateExprString(sqlQuery);
            } else {
                RolapStar.Table targetTable = column.getTable();
                hierarchy.addToFrom(sqlQuery, targetTable);
                columnString = column.generateExprString(sqlQuery);
            }
        } else {
            assert (aggStar == null);
            hierarchy.addToFrom(sqlQuery, level.getKeyExp());
            MondrianDef.Expression nameExp = level.getNameExp();
            if (nameExp == null) {
                nameExp = level.getKeyExp();
            }
            columnString = nameExp.getExpression(sqlQuery);
        }
        return columnString;
    }

    private static String generateMultiValueIsNullExprs(SqlQuery sqlQuery, RolapCube baseCube, RolapMember member, RolapLevel fromLevel, AggStar aggStar) {
        StringBuilder conditionBuf = new StringBuilder();
        conditionBuf.append("(");
        boolean isFirstLevelInMultiple = true;
        for (RolapMember m = member; m != null; m = m.getParentMember()) {
            if (m.isAll()) continue;
            String columnString = SqlConstraintUtils.getColumnString(sqlQuery, aggStar, m.getLevel(), baseCube);
            if (!isFirstLevelInMultiple) {
                conditionBuf.append(" or ");
            } else {
                isFirstLevelInMultiple = false;
            }
            conditionBuf.append(columnString);
            conditionBuf.append(" is null");
            if (m.getLevel() == fromLevel) break;
        }
        conditionBuf.append(")");
        return conditionBuf.toString();
    }

    private static String generateSingleValueInExpr(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, boolean exclude, boolean includeParentLevels) {
        int maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        Dialect dialect = sqlQuery.getDialect();
        String condition = "";
        boolean firstLevel = true;
        SequencedCollection<RolapMember> c = members;
        while (!c.isEmpty()) {
            RolapMember m2 = (RolapMember)c.iterator().next();
            if (!m2.isAll()) {
                if (m2.isNull()) {
                    return "1 = 0";
                }
                if (m2.isCalculated() && !m2.isParentChildLeaf()) {
                    if (restrictMemberTypes) {
                        throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m2);
                    }
                } else {
                    String q;
                    boolean containsNullKey = false;
                    for (RolapMember m2 : c) {
                        if (m2.getKey() != RolapUtil.sqlNullValue) continue;
                        containsNullKey = true;
                    }
                    RolapLevel level = m2.getLevel();
                    RolapHierarchy hierarchy = level.getHierarchy();
                    RolapStar.Column column = null;
                    if (level instanceof RolapCubeLevel) {
                        column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                    }
                    if (column != null) {
                        if (aggStar != null) {
                            int bitPos = column.getBitPosition();
                            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                            if (aggColumn == null) {
                                throw Util.newInternal("AggStar " + aggStar + " has no column for " + column + " (bitPos " + bitPos + ")");
                            }
                            AggStar.Table table = aggColumn.getTable();
                            table.addToFrom(sqlQuery, false, true);
                            q = aggColumn.generateExprString(sqlQuery);
                        } else {
                            RolapStar.Table targetTable = column.getTable();
                            hierarchy.addToFrom(sqlQuery, targetTable);
                            q = column.generateExprString(sqlQuery);
                        }
                    } else {
                        assert (aggStar == null);
                        hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                        q = level.getKeyExp().getExpression(sqlQuery);
                    }
                    StarColumnPredicate cc = SqlConstraintUtils.getColumnPredicates(column, c);
                    if (!dialect.supportsUnlimitedValueList() && cc instanceof ListColumnPredicate && ((ListColumnPredicate)cc).getPredicates().size() > maxConstraints) {
                        LOG.debug((Object)MondrianResource.instance().NativeSqlInClauseTooLarge.str(level.getUniqueName(), maxConstraints + ""));
                    } else {
                        String where = RolapStar.Column.createInExpr(q, cc, level.getDatatype(), sqlQuery);
                        if (!where.equals("true")) {
                            if (!firstLevel) {
                                condition = exclude ? condition + " or " : condition + " and ";
                            } else {
                                firstLevel = false;
                            }
                            if (exclude) {
                                where = "not (" + where + ")";
                                if (!containsNullKey) {
                                    where = "(" + where + " or " + "(" + q + " is null))";
                                }
                            }
                            condition = condition + where;
                        }
                    }
                    if (m2.getLevel().isUnique() || m2.getLevel() == fromLevel || !includeParentLevels) break;
                }
            }
            c = SqlConstraintUtils.getUniqueParentMembers(c);
        }
        return condition;
    }
}

