/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.ResumeTransitionXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.executor.jpa.CoordActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordResumeXCommand
extends ResumeTransitionXCommand {
    private final String jobId;
    private CoordinatorJobBean coordJob = null;
    private JPAService jpaService = null;
    private boolean exceptionOccured = false;
    Job.Status prevStatus;

    public CoordResumeXCommand(String id) {
        super("coord_resume", "coord_resume", 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.jobId));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        this.setJob((Job)this.coordJob);
        this.prevStatus = this.coordJob.getStatus();
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordJob.getStatus() != Job.Status.SUSPENDED && this.coordJob.getStatus() != Job.Status.PREPSUSPENDED) {
            throw new PreconditionException(ErrorCode.E1100, "CoordResumeXCommand not Resumed - job not in SUSPENDED/PREPSUSPENDED state, job = " + this.jobId);
        }
    }

    @Override
    public void updateJob() throws CommandException {
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        this.coordJob.setSuspendedTime(null);
        this.coordJob.setLastModifiedTime(new Date());
        this.LOG.debug("Resume coordinator job id = " + this.jobId + ", status = " + this.coordJob.getStatus() + ", pending = " + this.coordJob.isPending());
        try {
            this.jpaService.execute(new CoordJobUpdateJPAExecutor(this.coordJob));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void resumeChildren() throws CommandException {
        try {
            List<CoordinatorActionBean> actionList = this.jpaService.execute(new CoordJobGetActionsJPAExecutor(this.jobId));
            for (CoordinatorActionBean action : actionList) {
                if (action.getStatus() != CoordinatorAction.Status.SUSPENDED) continue;
                if (action.getExternalId() != null) {
                    this.queue(new ResumeXCommand(action.getExternalId()));
                    this.updateCoordAction(action);
                    this.LOG.debug("Resume coord action = [{0}], new status = [{1}], pending = [{2}] and queue ResumeXCommand for [{3}]", action.getId(), action.getStatus(), action.getPending(), action.getExternalId());
                    continue;
                }
                this.updateCoordAction(action);
                this.LOG.debug("Resume coord action = [{0}], new status = [{1}], pending = [{2}] and external id is null", action.getId(), action.getStatus(), action.getPending());
            }
        }
        catch (XException ex) {
            this.exceptionOccured = true;
            throw new CommandException(ex);
        }
        finally {
            if (this.exceptionOccured) {
                this.coordJob.setStatus(Job.Status.FAILED);
                this.coordJob.resetPending();
                this.LOG.warn("Resume children failed so fail coordinator, coordinator job id = " + this.jobId + ", status = " + this.coordJob.getStatus());
                try {
                    this.jpaService.execute(new CoordJobUpdateJPAExecutor(this.coordJob));
                }
                catch (JPAExecutorException je) {
                    this.LOG.error((Object)("Failed to update coordinator job : " + this.jobId), je);
                }
            }
        }
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }

    private void updateCoordAction(CoordinatorActionBean action) throws CommandException {
        action.setStatus(CoordinatorAction.Status.RUNNING);
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        try {
            this.jpaService.execute(new CoordActionUpdateJPAExecutor(action));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }
}

