/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JsonWorkflowJob;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.AuthorizationService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JobsServlet;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class JobServlet
extends JsonRestServlet {
    private static final String INSTRUMENTATION_NAME = "job";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public JobServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            String jobId = this.getResourceName(request);
            request.setAttribute("audit.param", (Object)jobId);
            request.setAttribute("audit.operation", (Object)request.getParameter("action"));
            try {
                AuthorizationService auth = Services.get().get(AuthorizationService.class);
                auth.authorizeForJob(this.getUser(request), jobId, true);
            }
            catch (AuthorizationException ex) {
                throw new XServletException(401, ex);
            }
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
            CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
            try {
                String action = request.getParameter("action");
                if (action.equals("start")) {
                    this.stopCron();
                    dagEngine.start(jobId);
                    this.startCron();
                    response.setStatus(200);
                    break block11;
                }
                if (action.equals("resume")) {
                    this.stopCron();
                    dagEngine.resume(jobId);
                    this.startCron();
                    response.setStatus(200);
                    break block11;
                }
                if (action.equals("suspend")) {
                    this.stopCron();
                    dagEngine.suspend(jobId);
                    this.startCron();
                    response.setStatus(200);
                    break block11;
                }
                if (action.equals("kill")) {
                    this.stopCron();
                    dagEngine.kill(jobId);
                    this.startCron();
                    response.setStatus(200);
                    break block11;
                }
                if (action.equals("rerun")) {
                    this.validateContentType(request, "application/xml");
                    XConfiguration conf = new XConfiguration((InputStream)request.getInputStream());
                    this.stopCron();
                    conf = conf.trim();
                    conf = conf.resolve();
                    JobsServlet.validateJobConfiguration(conf);
                    JobServlet.checkAuthorizationForApp(this.getUser(request), conf);
                    dagEngine.reRun(jobId, conf);
                    this.startCron();
                    response.setStatus(200);
                    break block11;
                }
                if (action.equals("coord-rerun")) {
                    this.validateContentType(request, "application/xml");
                    this.stopCron();
                    String rerunType = request.getParameter("type");
                    String scope = request.getParameter("scope");
                    String refresh = request.getParameter("refresh");
                    String noCleanup = request.getParameter("nocleanup");
                    CoordinatorActionInfo coordInfo = coordEngine.reRun(jobId, rerunType, scope, Boolean.valueOf(refresh), Boolean.valueOf(noCleanup));
                    List<CoordinatorActionBean> actions = coordInfo.getCoordActions();
                    JSONObject json = new JSONObject();
                    json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(actions));
                    this.startCron();
                    this.sendJsonResponse(response, 200, (JSONStreamAware)json);
                    break block11;
                }
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            catch (DagEngineException ex) {
                throw new XServletException(400, ex);
            }
            catch (BaseEngineException ex) {
                throw new XServletException(400, ex);
            }
        }
    }

    static void checkAuthorizationForApp(String requestUser, Configuration conf) throws XServletException {
        String user = conf.get("user.name");
        String group = conf.get("group.name");
        try {
            if (user == null) {
                throw new XServletException(400, ErrorCode.E0401, "user.name");
            }
            if (!requestUser.equals("?") && !user.equals(requestUser)) {
                throw new XServletException(400, ErrorCode.E0400, requestUser, user);
            }
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            if (group == null) {
                group = auth.getDefaultGroup(user);
                conf.set("group.name", group);
            } else {
                auth.authorizeForGroup(user, group);
            }
            XLog.Info.get().setParameter("GROUP", group);
            auth.authorizeForApp(user, group, conf.get("oozie.wf.application.path"), conf);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            String jobId = this.getResourceName(request);
            String show = request.getParameter("show");
            try {
                AuthorizationService auth = Services.get().get(AuthorizationService.class);
                auth.authorizeForJob(this.getUser(request), jobId, false);
            }
            catch (AuthorizationException ex) {
                throw new XServletException(401, ex);
            }
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
            try {
                if (show == null || show.equals("info")) {
                    this.stopCron();
                    JsonWorkflowJob job = (JsonWorkflowJob)dagEngine.getJob(jobId);
                    this.startCron();
                    this.sendJsonResponse(response, 200, job);
                    break block7;
                }
                if (show.equals("log")) {
                    response.setContentType("text/plain; charset=\"UTF-8\"");
                    dagEngine.streamLog(jobId, response.getWriter());
                    break block7;
                }
                if (show.equals("definition")) {
                    this.stopCron();
                    response.setContentType("application/xml; charset=\"UTF-8\"");
                    String wfDefinition = dagEngine.getDefinition(jobId);
                    this.startCron();
                    response.setStatus(200);
                    response.getWriter().write(wfDefinition);
                    break block7;
                }
                throw new XServletException(400, ErrorCode.E0303, "show", show);
            }
            catch (DagEngineException ex) {
                throw new XServletException(400, ex);
            }
        }
    }

    static {
        JobServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("*", Arrays.asList("PUT", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, true, Arrays.asList("PUT")), new JsonRestServlet.ParameterInfo("show", String.class, false, Arrays.asList("GET"))));
    }
}

