/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.olap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.olap.OlapUtils;

@Path(value="/{pluginId}/api/olap")
public class OlapApi {
    private static final Log logger = LogFactory.getLog(OlapApi.class);

    @GET
    @Path(value="/getCubes")
    @Produces(value={"text/javascript"})
    public void getCubes(@Context HttpServletResponse response) throws IOException, JSONException {
        OlapUtils olapUtils = new OlapUtils();
        JSONObject result = olapUtils.getOlapCubes();
        this.buildJsonResult((OutputStream)response.getOutputStream(), result != null, result);
    }

    @GET
    @Path(value="/getCubeStructure")
    @Produces(value={"text/javascript"})
    public void getCubeStructure(@QueryParam(value="catalog") String catalog, @QueryParam(value="cube") String cube, @QueryParam(value="jndi") String jndi, @Context HttpServletResponse response) throws IOException, JSONException {
        OlapUtils olapUtils = new OlapUtils();
        JSONObject result = olapUtils.getCubeStructure(catalog, cube, jndi);
        this.buildJsonResult((OutputStream)response.getOutputStream(), result != null, result);
    }

    @GET
    @Path(value="/getLevelMembersStructure")
    @Produces(value={"text/javascript"})
    public void getLevelMembersStructure(@QueryParam(value="catalog") String catalog, @QueryParam(value="cube") String cube, @QueryParam(value="member") String member, @QueryParam(value="direction") String direction, @Context HttpServletResponse response) throws IOException, JSONException {
        OlapUtils olapUtils = new OlapUtils();
        JSONObject result = olapUtils.getLevelMembersStructure(catalog, cube, member, direction);
        this.buildJsonResult((OutputStream)response.getOutputStream(), result != null, result);
    }

    @GET
    @Path(value="/getPaginatedLevelMembers")
    @Produces(value={"text/javascript"})
    public void getPaginatedLevelMembers(@QueryParam(value="catalog") String catalog, @QueryParam(value="cube") String cube, @QueryParam(value="level") String level, @QueryParam(value="startMember") String startMember, @QueryParam(value="context") String context, @QueryParam(value="searchTerm") String searchTerm, @QueryParam(value="pageSize") long pageSize, @QueryParam(value="pageStart") long pageStart, @Context HttpServletResponse response) throws IOException, JSONException {
        OlapUtils olapUtils = new OlapUtils();
        JSONObject result = olapUtils.getPaginatedLevelMembers(catalog, cube, level, startMember, context, searchTerm, pageSize, pageStart);
        this.buildJsonResult((OutputStream)response.getOutputStream(), result != null, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJsonResult(OutputStream out, Boolean sucess, Object result) throws JSONException {
        JSONObject jsonResult = new JSONObject();
        jsonResult.put("status", (Object)sucess.toString());
        if (result != null) {
            jsonResult.put("result", result);
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(out);
            pw.print(jsonResult.toString(2));
            pw.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)pw);
    }

    private class MethodParams {
        public static final String CATALOG = "catalog";
        public static final String CUBE = "cube";
        public static final String LEVEL = "level";
        public static final String JNDI = "jndi";
        public static final String MEMBER = "member";
        public static final String START_MEMBER = "startMember";
        public static final String DIRECTION = "direction";
        public static final String CONTEXT = "context";
        public static final String SEARCH_TERM = "searchTerm";
        public static final String PAGE_SIZE = "pageSize";
        public static final String PAGE_START = "pageStart";

        private MethodParams() {
        }
    }
}

