/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.RepositoryPathEncoder;

public class DownloadReportContentHandler {
    private IPentahoSession userSession;
    private IParameterProvider pathProvider;

    public DownloadReportContentHandler(IPentahoSession userSession, IParameterProvider pathProvider) {
        if (userSession == null) {
            throw new NullPointerException();
        }
        if (pathProvider == null) {
            throw new NullPointerException();
        }
        this.userSession = userSession;
        this.pathProvider = pathProvider;
    }

    public void createDownloadContent(OutputStream outputStream, String path) throws IOException {
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)this.userSession);
        RepositoryFile file = repository.getFile(this.idTopath(path));
        HttpServletResponse response = (HttpServletResponse)this.pathProvider.getParameter("httpresponse");
        if (!file.isFolder() && !file.getPath().equals("/")) {
            SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
            InputStream input = fileData.getStream();
            byte[] data = input.toString().getBytes();
            if (data == null) {
                response.setStatus(400);
            } else {
                response.setHeader("Content-Disposition", "attach; filename=\"" + file.getName() + "\"");
                response.setHeader("Content-Description", file.getName());
                response.setDateHeader("Last-Modified", file.getLastModifiedDate().getTime());
                response.setContentLength(data.length);
                response.setHeader("Cache-Control", "private, max-age=0, must-revalidate");
                outputStream.write(data);
            }
        } else {
            response.setStatus(403);
        }
    }

    private String idTopath(String id) {
        String path = RepositoryPathEncoder.encode((String)id);
        if (path != null && path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }
}

