/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.reporting.platform.plugin.DownloadReportContentHandler;
import org.pentaho.reporting.platform.plugin.ExecuteReportContentHandler;
import org.pentaho.reporting.platform.plugin.ParameterContentGenerator;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;

public class ReportContentGenerator
extends ParameterContentGenerator {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReportContentGenerator.class);

    @Override
    public void createContent(OutputStream outputStream) throws Exception {
        String id = UUIDUtil.getUUIDAsString();
        String path = null;
        RENDER_TYPE renderMode = null;
        this.setInstanceId(id);
        IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
        IParameterProvider requestParams = this.getRequestParameters();
        IParameterProvider pathParams = this.getPathParameters();
        if (requestParams != null && requestParams.getStringParameter("path", null) != null) {
            path = requestParams.getStringParameter("path", "");
        } else if (pathParams != null && pathParams.getStringParameter("path", null) != null) {
            path = pathParams.getStringParameter("path", "");
        }
        path = URLDecoder.decode(path, "UTF-8");
        if (requestParams != null && requestParams.getStringParameter("renderMode", null) != null) {
            renderMode = RENDER_TYPE.valueOf(requestParams.getStringParameter("renderMode", RENDER_TYPE.REPORT.toString()).toUpperCase());
        } else if (pathParams != null && pathParams.getStringParameter("renderMode", null) != null) {
            renderMode = RENDER_TYPE.valueOf(pathParams.getStringParameter("renderMode", RENDER_TYPE.REPORT.toString()).toUpperCase());
        }
        if (renderMode == null) {
            renderMode = RENDER_TYPE.REPORT;
        }
        RepositoryFile prptFile = unifiedRepository.getFile(path);
        try {
            switch (renderMode) {
                case DOWNLOAD: {
                    DownloadReportContentHandler contentHandler = new DownloadReportContentHandler(this.userSession, (IParameterProvider)this.parameterProviders.get("path"));
                    contentHandler.createDownloadContent(outputStream, this.idTopath(prptFile.getPath()));
                    break;
                }
                case REPORT: {
                    ExecuteReportContentHandler executeReportContentHandler = new ExecuteReportContentHandler(this);
                    executeReportContentHandler.createReportContent(outputStream, prptFile.getId(), prptFile.getPath(), false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (Exception ex) {
            String exceptionMessage = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName();
            log.error((Object)exceptionMessage, (Throwable)ex);
            if (outputStream != null) {
                outputStream.write(exceptionMessage.getBytes("UTF-8"));
                outputStream.flush();
            }
            throw new IllegalArgumentException();
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Map<String, IParameterProvider> getParameterProviders() {
        return this.parameterProviders;
    }

    @Override
    public Log getLogger() {
        return log;
    }

    @Override
    public String getMimeType() {
        IParameterProvider requestParams = this.getRequestParameters();
        IParameterProvider pathParams = this.getPathParameters();
        RENDER_TYPE renderMode = null;
        String path = null;
        IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
        if (requestParams != null && requestParams.getStringParameter("renderMode", null) != null) {
            renderMode = RENDER_TYPE.valueOf(requestParams.getStringParameter("renderMode", RENDER_TYPE.REPORT.toString()).toUpperCase());
        } else if (pathParams != null && pathParams.getStringParameter("renderMode", null) != null) {
            renderMode = RENDER_TYPE.valueOf(pathParams.getStringParameter("renderMode", RENDER_TYPE.REPORT.toString()).toUpperCase());
        }
        if (renderMode == null) {
            renderMode = RENDER_TYPE.REPORT;
        }
        if (renderMode.equals((Object)RENDER_TYPE.XML) || renderMode.equals((Object)RENDER_TYPE.PARAMETER)) {
            return "text/xml";
        }
        if (renderMode.equals((Object)RENDER_TYPE.DOWNLOAD)) {
            return "application/octet-stream";
        }
        try {
            if (requestParams != null && requestParams.getStringParameter("path", null) != null) {
                path = requestParams.getStringParameter("path", "");
            } else if (pathParams != null && pathParams.getStringParameter("path", null) != null) {
                path = pathParams.getStringParameter("path", "");
            }
            path = this.idTopath(URLDecoder.decode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        RepositoryFile prptFile = unifiedRepository.getFile(path);
        boolean isMobile = "true".equals(requestParams.getStringParameter("mobile", "false"));
        SimpleReportingComponent reportComponent = new SimpleReportingComponent();
        Map<String, Object> inputs = ReportContentGenerator.createInputs(requestParams);
        reportComponent.setForceDefaultOutputTarget(isMobile);
        if (prptFile.getPath().endsWith(".prpti")) {
            reportComponent.setForceUnlockPreferredOutput(true);
        }
        reportComponent.setDefaultOutputTarget("table/html;page-mode=page");
        reportComponent.setReportFileId(prptFile.getId());
        reportComponent.setInputs(inputs);
        return reportComponent.getMimeType();
    }

    public String getSystemRelativePluginPath(ClassLoader classLoader) {
        File dir = this.getPluginDir(classLoader);
        if (dir == null) {
            return null;
        }
        String path = dir.getAbsolutePath().replace("\\", "/");
        int pos = path.lastIndexOf("/system/");
        if (pos != -1) {
            path = path.substring(pos + 8);
        }
        return path;
    }

    protected File getPluginDir(ClassLoader classLoader) {
        if (classLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)classLoader).getPluginDir();
        }
        return null;
    }

    public static enum RENDER_TYPE {
        REPORT,
        XML,
        PARAMETER,
        DOWNLOAD;

    }
}

