/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoTableModel;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.platform.plugin.CommonUtil;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class ReportContentUtil {
    public static ValidationResult applyInputsToReportParameters(MasterReport report, ParameterContext context, Map<String, Object> inputs, ValidationResult validationResult) throws IOException, ResourceException {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        if (inputs != null) {
            Log log = LogFactory.getLog(SimpleReportingComponent.class);
            ParameterDefinitionEntry[] params = report.getParameterDefinition().getParameterDefinitions();
            ReportParameterValues parameterValues = report.getParameterValues();
            for (ParameterDefinitionEntry param : params) {
                String paramName = param.getName();
                try {
                    Object computedParameter = ReportContentUtil.computeParameterValue(context, param, inputs.get(paramName));
                    parameterValues.put(param.getName(), computedParameter);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)Messages.getInstance().getString("ReportPlugin.infoParameterValues", new Object[]{paramName, String.valueOf(inputs.get(paramName)), String.valueOf(computedParameter)}));
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)Messages.getInstance().getString("ReportPlugin.logErrorParametrization"), (Throwable)e);
                    }
                    validationResult.addError(paramName, new ValidationMessage(e.getMessage()));
                }
            }
        }
        return validationResult;
    }

    public static Object computeParameterValue(ParameterContext parameterContext, ParameterDefinitionEntry parameterDefinition, Object value) throws ReportProcessingException {
        if (value == null) {
            return null;
        }
        Class<?> valueType = parameterDefinition.getValueType();
        boolean allowMultiSelect = ReportContentUtil.isAllowMultiSelect(parameterDefinition);
        if (allowMultiSelect && Collection.class.isInstance(value)) {
            Collection c = (Collection)value;
            Class<?> componentType = valueType.isArray() ? valueType.getComponentType() : valueType;
            int length = c.size();
            Object[] sourceArray = c.toArray();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ReportContentUtil.convert(parameterContext, parameterDefinition, componentType, sourceArray[i]));
            }
            return array;
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = valueType.isArray() ? valueType.getComponentType() : valueType;
            int length = Array.getLength(value);
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ReportContentUtil.convert(parameterContext, parameterDefinition, componentType, Array.get(value, i)));
            }
            return array;
        }
        if (allowMultiSelect) {
            Object[] array = new Object[]{value};
            return ReportContentUtil.computeParameterValue(parameterContext, parameterDefinition, array);
        }
        return ReportContentUtil.convert(parameterContext, parameterDefinition, parameterDefinition.getValueType(), value);
    }

    private static boolean isAllowMultiSelect(ParameterDefinitionEntry parameter) {
        if (parameter instanceof ListParameter) {
            ListParameter listParameter = (ListParameter)parameter;
            return listParameter.isAllowMultiSelection();
        }
        return false;
    }

    private static Object convert(ParameterContext context, ParameterDefinitionEntry parameter, Class targetType, Object rawValue) throws ReportProcessingException {
        ValueConverter valueConverter;
        if (targetType == null) {
            throw new NullPointerException();
        }
        if (rawValue == null) {
            return null;
        }
        if (targetType.isInstance(rawValue)) {
            return rawValue;
        }
        if (targetType.isAssignableFrom(TableModel.class) && IPentahoResultSet.class.isAssignableFrom(rawValue.getClass())) {
            return new PentahoTableModel((IPentahoResultSet)rawValue);
        }
        String valueAsString = String.valueOf(rawValue);
        if (StringUtils.isEmpty((String)valueAsString)) {
            return null;
        }
        if (targetType.equals(Timestamp.class)) {
            try {
                java.util.Date date = ReportContentUtil.parseDate(parameter, context, valueAsString);
                return new Timestamp(date.getTime());
            }
            catch (ParseException pe) {
                CommonUtil.checkStyleIgnore();
            }
        } else if (targetType.equals(Time.class)) {
            try {
                java.util.Date date = ReportContentUtil.parseDate(parameter, context, valueAsString);
                return new Time(date.getTime());
            }
            catch (ParseException pe) {
                CommonUtil.checkStyleIgnore();
            }
        } else if (targetType.equals(Date.class)) {
            try {
                java.util.Date date = ReportContentUtil.parseDate(parameter, context, valueAsString);
                return new Date(date.getTime());
            }
            catch (ParseException pe) {
                CommonUtil.checkStyleIgnore();
            }
        } else if (targetType.equals(java.util.Date.class)) {
            try {
                java.util.Date date = ReportContentUtil.parseDate(parameter, context, valueAsString);
                return new java.util.Date(date.getTime());
            }
            catch (ParseException pe) {
                CommonUtil.checkStyleIgnore();
            }
        }
        String dataFormat = parameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", context);
        if (dataFormat != null) {
            try {
                if (Number.class.isAssignableFrom(targetType)) {
                    DecimalFormat format = new DecimalFormat(dataFormat, new DecimalFormatSymbols(LocaleHelper.getLocale()));
                    format.setParseBigDecimal(true);
                    Number number = format.parse(valueAsString);
                    String asText = ConverterRegistry.toAttributeValue((Object)number);
                    return ConverterRegistry.toPropertyValue((String)asText, (Class)targetType);
                }
                if (java.util.Date.class.isAssignableFrom(targetType)) {
                    SimpleDateFormat format = new SimpleDateFormat(dataFormat, new DateFormatSymbols(LocaleHelper.getLocale()));
                    format.setLenient(false);
                    java.util.Date number = format.parse(valueAsString);
                    String asText = ConverterRegistry.toAttributeValue((Object)number);
                    return ConverterRegistry.toPropertyValue((String)asText, (Class)targetType);
                }
            }
            catch (Exception e) {
                CommonUtil.checkStyleIgnore();
            }
        }
        if ((valueConverter = ConverterRegistry.getInstance().getValueConverter(targetType)) != null) {
            try {
                return valueConverter.toPropertyValue(valueAsString);
            }
            catch (BeanException e) {
                throw new ReportProcessingException(Messages.getInstance().getString("ReportPlugin.unableToConvertParameter", new Object[]{parameter.getName(), valueAsString}));
            }
        }
        return rawValue;
    }

    private static java.util.Date parseDate(ParameterDefinitionEntry parameterEntry, ParameterContext context, String value) throws ParseException {
        try {
            return ReportContentUtil.parseDateStrict(parameterEntry, context, value);
        }
        catch (ParseException pe) {
            CommonUtil.checkStyleIgnore();
            try {
                Long dateAsLong = Long.parseLong(value);
                return new java.util.Date(dateAsLong);
            }
            catch (NumberFormatException nfe) {
                CommonUtil.checkStyleIgnore();
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    return simpleDateFormat.parse(value);
                }
                catch (ParseException pe2) {
                    CommonUtil.checkStyleIgnore();
                    throw new ParseException("Unable to parse Date", 0);
                }
            }
        }
    }

    private static java.util.Date parseDateStrict(ParameterDefinitionEntry parameterEntry, ParameterContext context, String value) throws ParseException {
        String timezoneSpec = parameterEntry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", context);
        if (timezoneSpec == null || "server".equals(timezoneSpec)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            return simpleDateFormat.parse(value);
        }
        if ("utc".equals(timezoneSpec)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat.parse(value);
        }
        if ("client".equals(timezoneSpec)) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                return simpleDateFormat.parse(value);
            }
            catch (ParseException pe) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                return simpleDateFormat.parse(value);
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(timezoneSpec);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.parse(value);
    }
}

