/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class RepositoryResourceData
extends AbstractResourceData {
    public static final String PENTAHO_REPOSITORY_KEY = "pentahoRepositoryKey";
    private String filename;
    private ResourceKey key;

    public RepositoryResourceData(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.filename = (String)key.getIdentifier();
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        IUnifiedRepository unifiedRepository = null;
        try {
            unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
            RepositoryFile repositoryFile = unifiedRepository.getFile(this.key.getIdentifierAsString());
            if (repositoryFile == null) {
                repositoryFile = unifiedRepository.getFileById((Serializable)((Object)this.key.getIdentifierAsString()));
            }
            if (repositoryFile == null) {
                throw new ResourceLoadingException();
            }
            InputStream stream = this.convert(repositoryFile);
            if (stream != null) {
                return stream;
            }
            SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)unifiedRepository.getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class);
            return fileData.getStream();
        }
        catch (UnifiedRepositoryException ex) {
            throw new ResourceLoadingException(ex.getLocalizedMessage(), (Exception)((Object)ex));
        }
    }

    private InputStream convert(RepositoryFile repositoryFile) {
        String extension;
        Converter converter;
        IRepositoryContentConverterHandler converterHandler = (IRepositoryContentConverterHandler)PentahoSystem.get(IRepositoryContentConverterHandler.class);
        if (converterHandler != null && (converter = converterHandler.getConverter(extension = FilenameUtils.getExtension((String)repositoryFile.getPath()))) != null) {
            InputStream stream = converter.convert(repositoryFile.getId());
            return stream;
        }
        return null;
    }

    public Object getAttribute(String lookupKey) {
        if (lookupKey.equals("filename")) {
            return this.filename;
        }
        return null;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        RepositoryFile repositoryFile = null;
        try {
            repositoryFile = unifiedRepository.getFile(this.key.getIdentifier().toString());
            if (repositoryFile != null) {
                return repositoryFile.getLastModifiedDate().getTime();
            }
            return -1L;
        }
        catch (UnifiedRepositoryException ex) {
            try {
                repositoryFile = unifiedRepository.getFileById((Serializable)((Object)this.key.getIdentifier().toString()));
            }
            catch (UnifiedRepositoryException exception) {
                return -1L;
            }
            if (repositoryFile != null) {
                return repositoryFile.getLastModifiedDate().getTime();
            }
            return -1L;
        }
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

