/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.reporting.engine.classic.core.util.StagingMode;
import org.pentaho.reporting.libraries.base.util.MemoryByteArrayOutputStream;
import org.pentaho.reporting.platform.plugin.CommonUtil;
import org.pentaho.reporting.platform.plugin.TrackingOutputStream;

public class StagingHandler {
    private static final Log logger = LogFactory.getLog(StagingHandler.class);
    private OutputStream destination;
    private TrackingOutputStream stagingStream;
    private File tmpFile;
    private StagingMode mode;
    private IPentahoSession userSession;

    public StagingHandler(OutputStream outputStream, StagingMode stagingMode, IPentahoSession userSession) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (stagingMode == null) {
            throw new NullPointerException();
        }
        this.userSession = userSession;
        this.destination = outputStream;
        this.initialize(stagingMode);
    }

    public StagingMode getStagingMode() {
        return this.mode;
    }

    public boolean isFullyBuffered() {
        return this.mode != StagingMode.THRU;
    }

    public boolean canSendHeaders() {
        return this.mode != StagingMode.THRU || this.getWrittenByteCount() <= 0;
    }

    private void initialize(StagingMode mode) throws IOException {
        this.mode = mode;
        logger.trace((Object)("Staging mode set - " + mode));
        if (mode == StagingMode.MEMORY) {
            this.createTrackingProxy((OutputStream)new MemoryByteArrayOutputStream());
        } else if (mode == StagingMode.TMPFILE) {
            IApplicationContext appCtx = PentahoSystem.getApplicationContext();
            if (this.userSession.getId().length() >= 10) {
                this.tmpFile = appCtx.createTempFile(this.userSession, "repstg", ".tmp", true);
            } else {
                File parentDir = new File(appCtx.getSolutionPath("system/tmp"));
                ITempFileDeleter fileDeleter = (ITempFileDeleter)this.userSession.getAttribute("PENTAHO_TMP_DELETER");
                String newPrefix = "repstg" + UUIDUtil.getUUIDAsString().substring(0, 10) + '-';
                this.tmpFile = File.createTempFile(newPrefix, ".tmp", parentDir);
                if (fileDeleter != null) {
                    fileDeleter.trackTempFile(this.tmpFile);
                } else {
                    this.tmpFile.deleteOnExit();
                }
            }
            this.createTrackingProxy(new BufferedOutputStream(new FileOutputStream(this.tmpFile)));
        } else {
            this.createTrackingProxy(this.destination);
        }
    }

    public OutputStream getStagingOutputStream() {
        return this.stagingStream;
    }

    private void createTrackingProxy(OutputStream streamToTrack) {
        this.stagingStream = new TrackingOutputStream(streamToTrack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() throws IOException {
        if (this.mode == StagingMode.MEMORY) {
            MemoryByteArrayOutputStream stream = (MemoryByteArrayOutputStream)this.stagingStream.getWrappedStream();
            byte[] bytes = stream.getRaw();
            this.destination.write(bytes, 0, stream.getLength());
            this.destination.flush();
        } else if (this.mode == StagingMode.TMPFILE) {
            IOUtils.closeQuietly((OutputStream)this.stagingStream);
            this.stagingStream = null;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.tmpFile));
            try {
                IOUtils.copy((InputStream)bis, (OutputStream)this.destination);
            }
            finally {
                IOUtils.closeQuietly((InputStream)bis);
            }
        }
        this.close();
    }

    public void close() {
        if (this.stagingStream != null && this.mode == StagingMode.TMPFILE) {
            IOUtils.closeQuietly((OutputStream)this.stagingStream);
            this.stagingStream = null;
        }
        if (this.tmpFile != null) {
            if (this.tmpFile.exists()) {
                try {
                    this.tmpFile.delete();
                }
                catch (Exception ignored) {
                    CommonUtil.checkStyleIgnore();
                }
            }
            this.tmpFile = null;
        }
    }

    public int getWrittenByteCount() {
        assert (this.stagingStream != null);
        return this.stagingStream.getTrackingSize();
    }
}

