/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.connection;

import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import mondrian.olap.Connection;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DefaultMondrianConnectionProvider;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class PentahoMondrianConnectionProvider
extends DefaultMondrianConnectionProvider {
    public static final String MDX_CONNECTION_MAPPER_KEY = "Mondrian-UserRoleMapper";

    public Connection createConnection(Properties properties, DataSource dataSource) throws ReportDataFactoryException {
        try {
            String catalog;
            String roleFromPentaho;
            String role = properties.getProperty("Role");
            if (StringUtils.isEmpty((String)role) && !StringUtils.isEmpty((String)(roleFromPentaho = this.computeRoleString(catalog = properties.getProperty("Catalog"))))) {
                properties.setProperty("Role", roleFromPentaho);
            }
            return super.createConnection(properties, dataSource);
        }
        catch (PentahoAccessControlException e) {
            throw new ReportDataFactoryException("Failed to map roles", (Throwable)e);
        }
    }

    private String computeRoleString(String catalog) throws PentahoAccessControlException {
        String[] validMondrianRolesForUser;
        IConnectionUserRoleMapper mondrianUserRoleMapper;
        if (PentahoSystem.getObjectFactory().objectDefined(MDX_CONNECTION_MAPPER_KEY) && (mondrianUserRoleMapper = (IConnectionUserRoleMapper)PentahoSystem.get(IConnectionUserRoleMapper.class, (String)MDX_CONNECTION_MAPPER_KEY, null)) != null && (validMondrianRolesForUser = mondrianUserRoleMapper.mapConnectionRoles(PentahoSessionHolder.getSession(), catalog)) != null && validMondrianRolesForUser.length > 0) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < validMondrianRolesForUser.length; ++i) {
                String aRole = validMondrianRolesForUser[i];
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(aRole.replaceAll(",", ",,"));
            }
            return buff.toString();
        }
        return null;
    }

    public Object getConnectionHash(Properties properties) throws ReportDataFactoryException {
        try {
            ArrayList hash = (ArrayList)super.getConnectionHash(properties);
            String catalog = properties.getProperty("Catalog");
            hash.add(this.computeRoleString(catalog));
            return hash;
        }
        catch (PentahoAccessControlException e) {
            throw new ReportDataFactoryException("Failed to map roles", (Throwable)e);
        }
    }
}

