/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.connection;

import java.sql.Connection;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdConnectionProvider;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.platform.plugin.CommonUtil;
import org.pentaho.reporting.platform.plugin.connection.PentahoJndiDatasourceConnectionProvider;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class PentahoPmdConnectionProvider
extends PmdConnectionProvider {
    public IMetadataDomainRepository getMetadataDomainRepository(String domain, ResourceManager resourceManager, ResourceKey contextKey, String xmiFile) throws ReportDataFactoryException {
        return (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, null);
    }

    public Connection createConnection(DatabaseMeta databaseMeta, String username, String password) throws ReportDataFactoryException {
        try {
            String jndiName;
            String realPassword;
            String realUser = databaseMeta.getUsername() == null ? username : databaseMeta.getUsername();
            String string = realPassword = databaseMeta.getPassword() == null ? password : databaseMeta.getPassword();
            if (databaseMeta.getAccessType() == 4 && (jndiName = databaseMeta.getDatabaseName()) != null) {
                try {
                    PentahoJndiDatasourceConnectionProvider connectionProvider = new PentahoJndiDatasourceConnectionProvider();
                    connectionProvider.setJndiName(jndiName);
                    return connectionProvider.createConnection(realUser, realPassword);
                }
                catch (Exception e) {
                    CommonUtil.checkStyleIgnore();
                }
            }
        }
        catch (Exception e) {
            throw new ReportDataFactoryException(Messages.getInstance().getString("ReportPlugin.unableToCreateConnection"), (Throwable)e);
        }
        return super.createConnection(databaseMeta, username, password);
    }
}

