/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.drilldown;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.function.formula.QuoteTextFunction;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.typing.sequence.RecursiveSequence;

public class ContentLinkFunction
implements Function {
    public String getCanonicalName() {
        return "CONTENTLINK";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        String[] contentLink = this.getContentLink(context);
        if (contentLink.length == 0) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Object o = parameters.getValue(0);
        Type type = parameters.getType(0);
        HashMap<String, Object[]> values = this.collectParameterValues(o, type, context);
        StringBuilder builder = new StringBuilder();
        builder.append("javascript:");
        for (int i = 0; i < contentLink.length; ++i) {
            String variable = contentLink[i];
            builder.append("var wnd=window.parent;var slf;while(!(wnd.Dashboards && wnd.Dashboards.fireOutputParam) && wnd.parent && wnd.parent !== wnd){slf=wnd;wnd=wnd.parent};wnd.Dashboards.fireOutputParam(slf,");
            builder.append('\'');
            builder.append(QuoteTextFunction.saveConvert((String)variable));
            builder.append('\'');
            builder.append(",");
            Object[] objects = values.get(variable);
            if (objects == null || objects.length == 0) {
                builder.append("null");
            } else if (objects.length == 1) {
                builder.append('\'');
                builder.append(QuoteTextFunction.saveConvert((String)String.valueOf(objects[0])));
                builder.append('\'');
            } else {
                builder.append("new Array(");
                for (int j = 0; j < objects.length; ++j) {
                    if (j != 0) {
                        builder.append(",");
                    }
                    builder.append('\'');
                    builder.append(QuoteTextFunction.saveConvert((String)String.valueOf(objects[j])));
                    builder.append('\'');
                }
                builder.append(")");
            }
            builder.append(");");
        }
        String value = builder.toString();
        return new TypeValuePair((Type)TextType.TYPE, (Object)value);
    }

    private String[] getContentLink(FormulaContext context) {
        if (!(context instanceof ReportFormulaContext)) {
            return new String[0];
        }
        ReportFormulaContext reportFormulaContext = (ReportFormulaContext)context;
        ReportEnvironment environment = reportFormulaContext.getRuntime().getProcessingContext().getEnvironment();
        Object clText = environment.getEnvironmentProperty("contentLink");
        if (clText == null) {
            return new String[0];
        }
        CSVTokenizer csvTokenizer = new CSVTokenizer(String.valueOf(clText), ",", "\"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (csvTokenizer.hasMoreTokens()) {
            String el = csvTokenizer.nextToken();
            result.add(el);
        }
        return result.toArray(new String[result.size()]);
    }

    private HashMap<String, Object[]> collectParameterValues(Object o, Type type, FormulaContext context) throws EvaluationException {
        HashMap<String, Object[]> params = new HashMap<String, Object[]>();
        if (o instanceof Object[][]) {
            Object[][] o2 = (Object[][])o;
            for (int i = 0; i < o2.length; ++i) {
                Object[] values = o2[i];
                if (values == null || values.length < 2) {
                    throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
                }
                Object value = values[1];
                if (value instanceof Object[]) {
                    params.put(String.valueOf(values[0]), (Object[])value);
                    continue;
                }
                params.put(String.valueOf(values[0]), new Object[]{value});
            }
        } else {
            ArrayCallback callback = context.getTypeRegistry().convertToArray(type, o);
            if (callback.getColumnCount() != 2) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            int n = callback.getRowCount();
            for (int i = 0; i < n; ++i) {
                Sequence sequenceRaw = context.getTypeRegistry().convertToSequence(callback.getType(i, 1), callback.getValue(i, 1));
                if (sequenceRaw == null) {
                    throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_NA_VALUE);
                }
                RecursiveSequence sequence = new RecursiveSequence((Object)sequenceRaw, context);
                ArrayList<Object> retval = new ArrayList<Object>();
                while (sequence.hasNext()) {
                    Object s = sequence.next();
                    retval.add(s);
                }
                params.put(String.valueOf(callback.getValue(i, 0)), retval.toArray());
            }
        }
        return params;
    }
}

