/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailURLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.email.EmailRepository;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class EmailOutput
implements ReportOutputHandler {
    @Override
    public Object getReportLock() {
        return this;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        int n;
        IApplicationContext ctx = PentahoSystem.getApplicationContext();
        if (ctx == null) {
            return -1;
        }
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props);
        EmailRepository dataRepository = new EmailRepository(session);
        ContentLocation dataLocation = dataRepository.getRoot();
        StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(report.getConfiguration());
        AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
        printer.setContentWriter(dataLocation, (NameGenerator)new DefaultNameGenerator(dataLocation, "index", "html"));
        printer.setDataWriter(dataLocation, (NameGenerator)new DefaultNameGenerator(dataLocation));
        printer.setUrlRewriter((URLRewriter)new MailURLRewriter());
        outputProcessor.setPrinter((HtmlPrinter)printer);
        StreamReportProcessor sp = new StreamReportProcessor(report, (OutputProcessor)outputProcessor);
        if (yieldRate > 0) {
            sp.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
        }
        try {
            sp.processReport();
            dataRepository.writeEmail(outputStream);
            outputStream.flush();
            n = 0;
        }
        catch (Throwable throwable) {
            try {
                sp.close();
                throw throwable;
            }
            catch (MessagingException e) {
                throw new ReportProcessingException("Error", (Exception)((Object)e));
            }
        }
        sp.close();
        return n;
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public void close() {
    }
}

