/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class PlainTextOutput
implements ReportOutputHandler {
    private ProxyOutputStream proxyOutputStream;

    @Override
    public Object getReportLock() {
        return this;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        PageableReportProcessor proc = this.create(report, yieldRate);
        this.proxyOutputStream.setParent(outputStream);
        try {
            if (!proc.isPaginated()) {
                proc.paginate();
            }
            proc.processReport();
            int n = 0;
            return n;
        }
        finally {
            proc.close();
            this.proxyOutputStream.setParent(null);
        }
    }

    private PageableReportProcessor create(MasterReport report, int yieldRate) throws ReportProcessingException {
        this.proxyOutputStream = new ProxyOutputStream();
        TextFilePrinterDriver driver = new TextFilePrinterDriver((OutputStream)this.proxyOutputStream, 12.0f, 6.0f);
        PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor((PrinterDriver)driver, report.getConfiguration());
        PageableReportProcessor proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
        if (yieldRate > 0) {
            proc.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
        }
        return proc;
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public void close() {
    }
}

