/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xml.XmlTableOutputProcessor;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class XmlTableOutput
implements ReportOutputHandler {
    private StreamReportProcessor proc;
    private ProxyOutputStream proxyOutputStream;

    @Override
    public Object getReportLock() {
        return this;
    }

    private StreamReportProcessor createProcessor(MasterReport report, int yieldRate) throws ReportProcessingException {
        this.proxyOutputStream = new ProxyOutputStream();
        XmlTableOutputProcessor target = new XmlTableOutputProcessor((OutputStream)this.proxyOutputStream);
        StreamReportProcessor proc = new StreamReportProcessor(report, (OutputProcessor)target);
        if (yieldRate > 0) {
            proc.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
        }
        return proc;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException {
        try {
            if (this.proc == null) {
                this.proc = this.createProcessor(report, yieldRate);
            }
            this.proxyOutputStream.setParent(outputStream);
            this.proc.processReport();
            int n = 0;
            return n;
        }
        finally {
            this.proxyOutputStream.setParent(null);
            outputStream.flush();
        }
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public void close() {
        if (this.proc != null) {
            this.proc.close();
            this.proc = null;
            this.proxyOutputStream = null;
        }
    }
}

