/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.repository;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriteException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;

public class PentahoURLRewriter
implements URLRewriter {
    private String pattern;
    private boolean useContentIdAsName;

    public PentahoURLRewriter(String pattern, boolean useContentIdAsName) {
        this.pattern = pattern;
        this.useContentIdAsName = useContentIdAsName;
    }

    public String rewrite(ContentEntity contentEntry, ContentEntity dataEntity) throws URLRewriteException {
        try {
            ContentLocation location;
            ArrayList<String> entityNames = new ArrayList<String>();
            entityNames.add(this.useContentIdAsName ? dataEntity.getContentId().toString() : dataEntity.getName());
            for (location = dataEntity.getParent(); location != null; location = location.getParent()) {
                entityNames.add(location.getName());
            }
            ArrayList<String> contentNames = new ArrayList<String>();
            for (location = dataEntity.getRepository().getRoot(); location != null; location = location.getParent()) {
                contentNames.add(location.getName());
            }
            while (!contentNames.isEmpty() && !entityNames.isEmpty()) {
                String lastEntity = (String)entityNames.get(entityNames.size() - 1);
                String lastContent = (String)contentNames.get(contentNames.size() - 1);
                if (!lastContent.equals(lastEntity)) break;
                entityNames.remove(entityNames.size() - 1);
                contentNames.remove(contentNames.size() - 1);
            }
            StringBuffer b = new StringBuffer();
            for (int i = entityNames.size() - 1; i >= 0; --i) {
                String name = (String)entityNames.get(i);
                b.append(name);
                if (i == 0) continue;
                b.append("/");
            }
            if (this.pattern == null) {
                return b.toString();
            }
            return MessageFormat.format(this.pattern, b.toString());
        }
        catch (ContentIOException cioe) {
            throw new URLRewriteException();
        }
    }
}

