/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileOutputStream;
import org.pentaho.platform.util.RepositoryPathEncoder;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.platform.plugin.repository.ReportContentLocation;

public class ReportContentItem
implements ContentItem {
    private ReportContentLocation parent;
    private RepositoryFile file;
    private String mimeType;

    public ReportContentItem(RepositoryFile file, ReportContentLocation parent, String mimeType) {
        this.file = file;
        this.parent = parent;
        this.mimeType = mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() throws ContentIOException {
        return this.mimeType;
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return new RepositoryFileOutputStream(this.file);
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        SimpleRepositoryFileData data = (SimpleRepositoryFileData)repo.getDataForRead(this.file.getId(), SimpleRepositoryFileData.class);
        return data.getInputStream();
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getName() {
        return this.file.getName();
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.file.getFileSize());
            }
            if ("version".equals(key)) {
                return this.file.getLastModifiedDate();
            }
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.parent.getRepository();
    }

    public boolean delete() {
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        repo.deleteFile(this.file.getId(), "PRE:DELETE");
        return true;
    }

    public Object getContentId() {
        return RepositoryPathEncoder.encode((String)this.file.getPath());
    }
}

