/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.vfs.KettleVFS;

public class Log4jFileAppender
implements Appender {
    private Layout layout;
    private Filter filter;
    private FileObject file;
    private String name;
    private OutputStream fileOutputStream;

    public Log4jFileAppender(FileObject file) throws IOException {
        this.file = file;
        this.fileOutputStream = KettleVFS.getOutputStream((FileObject)file, (boolean)false);
    }

    public Log4jFileAppender(FileObject file, boolean append) throws IOException {
        this.file = file;
        this.fileOutputStream = KettleVFS.getOutputStream((FileObject)file, (boolean)append);
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
        try {
            this.fileOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Unable to close Logging file [" + this.file.getName() + "] : " + e.getMessage());
        }
    }

    public void doAppend(LoggingEvent event) {
        String line = this.layout.format(event) + Const.CR;
        try {
            this.fileOutputStream.write(line.getBytes("UTF-8"));
        }
        catch (IOException e) {
            System.out.println("Unable to close Logging file [" + this.file.getName() + "] : " + e.getMessage());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFilename(FileObject file) {
        this.file = file;
    }

    public OutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    public void setFileOutputStream(OutputStream fileOutputStream) {
        this.fileOutputStream = fileOutputStream;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

