/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.IPentahoSessionHolderStrategy;
import org.pentaho.platform.engine.core.system.StandaloneSession;

public class InheritableThreadLocalPentahoSessionHolderStrategy
implements IPentahoSessionHolderStrategy {
    private static final Log logger = LogFactory.getLog(InheritableThreadLocalPentahoSessionHolderStrategy.class);
    private static final ThreadLocal<IPentahoSession> perThreadSession = new InheritableThreadLocal<IPentahoSession>();

    @Override
    public void setSession(IPentahoSession session) {
        perThreadSession.set(session);
    }

    @Override
    public IPentahoSession getSession() {
        IPentahoSession sess = perThreadSession.get();
        if (sess == null) {
            logger.debug((Object)Messages.getInstance().getString("PentahoSessionHolder.WARN_THREAD_SESSION_NULL", Thread.currentThread().getName()));
        }
        return sess;
    }

    @Override
    public void removeSession() {
        IPentahoSession sess = perThreadSession.get();
        if (sess != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("PentahoSessionHolder.DEBUG_REMOVING_SESSION", Thread.currentThread().getName(), String.valueOf(Thread.currentThread().getId())));
            }
            if (logger.isTraceEnabled()) {
                StackTraceElement[] elements = Thread.currentThread().getStackTrace();
                logger.trace((Object)Messages.getInstance().getString("PentahoSessionHolder.DEBUG_THREAD_STACK_TRACE"));
                for (int i = 0; i < elements.length; ++i) {
                    logger.trace((Object)elements[i]);
                }
            }
            if (sess instanceof StandaloneSession) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("PentahoSessionHolder.DEBUG_DESTROY_STANDALONE_SESSION", String.valueOf(sess.getId()), sess.getName(), String.valueOf(Thread.currentThread().getId())));
                }
                ((StandaloneSession)sess).destroy();
            }
            perThreadSession.remove();
        }
    }
}

