/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls.voter;

import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.security.acls.voter.PentahoBasicAclVoter;
import org.springframework.security.Authentication;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.userdetails.UserDetails;

public class PentahoUserOverridesVoter
extends PentahoBasicAclVoter {
    @Override
    public AclEntry[] getEffectiveAcls(IPentahoSession session, IAclHolder holder) {
        Authentication auth = this.getAuthentication(session);
        if (auth == null) {
            return null;
        }
        AclEntry[] objectAcls = super.getEffectiveAcls(session, holder);
        if (objectAcls == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        String userName = null;
        userName = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        for (AclEntry element : objectAcls) {
            BasicAclEntry entry = (BasicAclEntry)element;
            String recipient = entry.getRecipient().toString();
            if (!recipient.equals(userName)) continue;
            return new AclEntry[]{entry};
        }
        return objectAcls;
    }
}

