/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class NonPooledDatasourceSystemListener
implements IPentahoSystemListener {
    public boolean startup(IPentahoSession session) {
        try {
            Logger.debug(this, "DatasourceSystemListener: called for startup ...");
            ICacheManager cacheManager = this.addCacheRegions();
            List<IDatabaseConnection> databaseConnections = this.getListOfDatabaseConnections(session);
            String dsName = "";
            DataSource ds = null;
            for (IDatabaseConnection databaseConnection : databaseConnections) {
                if (databaseConnection == null) continue;
                Logger.debug(this, "  Setting up datasource - " + databaseConnection);
                ds = this.isPortUsedByServer(databaseConnection) ? null : this.setupDataSourceForConnection(databaseConnection);
                dsName = databaseConnection.getName();
                cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)ds);
                Logger.debug(this, "(Storing datasource under key \"DataSource" + dsName + "\")");
            }
            Logger.debug(this, "DatasourceSystemListener: Completed startup.");
            return true;
        }
        catch (ObjectFactoryException objface) {
            Logger.error(this, Messages.getInstance().getErrorString("DatasourceSystemListener.ERROR_0001_UNABLE_TO_INSTANTIATE_OBJECT"), (Throwable)objface);
            return false;
        }
        catch (DatasourceMgmtServiceException dmse) {
            Logger.error(this, Messages.getInstance().getErrorString("DatasourceSystemListener.ERROR_0002_UNABLE_TO_GET_DATASOURCE"), (Throwable)dmse);
            return false;
        }
    }

    public void shutdown() {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        Logger.debug(this, "DatasourceSystemListener: Called for shutdown ...");
        cacheManager.removeRegionCache("DataSource");
        Logger.debug(this, "DatasourceSystemListener: Completed shutdown.");
    }

    protected DataSource getDataSource(IDatabaseConnection connection) throws DBDatasourceServiceException {
        return PooledDatasourceHelper.convert(connection);
    }

    protected ICacheManager addCacheRegions() {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        Logger.debug(this, "Adding caching regions ...");
        if (!cacheManager.cacheEnabled("DataSource")) {
            cacheManager.addCacheRegion("DataSource");
        }
        return cacheManager;
    }

    @VisibleForTesting
    protected List<IDatabaseConnection> getListOfDatabaseConnections(IPentahoSession session) throws ObjectFactoryException, DatasourceMgmtServiceException {
        IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.getObjectFactory().get(IDatasourceMgmtService.class, session);
        List databaseConnections = datasourceMgmtSvc.getDatasources();
        return databaseConnections;
    }

    @VisibleForTesting
    protected boolean isPortUsedByServer(IDatabaseConnection databaseConnection) {
        String connectionHostName = databaseConnection.getHostname();
        InetAddress connectionAddress = null;
        try {
            connectionAddress = this.getAdressFromString(connectionHostName);
        }
        catch (UnknownHostException e) {
            Logger.warn(this, Messages.getInstance().getErrorString("DatasourceSystemListener.WARN_0001_UNABLE_TO_GET_CONNECTION_ADDRESS"), (Throwable)e);
            return false;
        }
        String stringConnectionPort = databaseConnection.getDatabasePort();
        String fullyQualifiedServerURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        URL url = null;
        try {
            url = new URL(fullyQualifiedServerURL);
        }
        catch (MalformedURLException e) {
            Logger.warn(this, Messages.getInstance().getErrorString("DatasourceSystemListener.WARN_0002_UNABLE_TO_PARSE_SERVER_URL"), (Throwable)e);
            return false;
        }
        String hostNameUsedByServer = url.getHost();
        InetAddress serverAddress = null;
        try {
            serverAddress = this.getAdressFromString(hostNameUsedByServer);
        }
        catch (UnknownHostException e) {
            Logger.warn(this, Messages.getInstance().getErrorString("DatasourceSystemListener.WARN_0003_UNABLE_TO_GET_SERVER_ADDRESS"), (Throwable)e);
            return false;
        }
        int portUsedByServer = url.getPort();
        boolean isAddressesEquals = connectionAddress.equals(serverAddress);
        boolean isPortsEquals = false;
        try {
            Integer connectionPort = Integer.valueOf(stringConnectionPort);
            isPortsEquals = connectionPort.equals(portUsedByServer);
        }
        catch (NumberFormatException e) {
            Logger.warn(this, Messages.getInstance().getErrorString("DatasourceSystemListener.WARN_0004_UNABLE_TO_GET_PORT_NUMBER"), (Throwable)e);
            return false;
        }
        return isAddressesEquals && isPortsEquals;
    }

    @VisibleForTesting
    protected DataSource setupDataSourceForConnection(IDatabaseConnection databaseConnection) {
        DataSource ds = null;
        try {
            ds = this.getDataSource(databaseConnection);
        }
        catch (DBDatasourceServiceException e) {
            Logger.error(this, "Error retrieving DataSource", (Throwable)e);
        }
        return ds;
    }

    private InetAddress getAdressFromString(String connectionHostName) throws UnknownHostException {
        InetAddress address = null;
        address = InetAddress.getByName(connectionHostName);
        return address;
    }
}

