/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IParameterProvider;
import pt.webdetails.cpf.RequestHandler;
import pt.webdetails.cpf.utils.CharsetHelper;

public abstract class JsonRequestHandler
implements RequestHandler {
    public static String JSON_REQUEST_PARAM = "payload";

    public void call(OutputStream out, IParameterProvider pathParams, IParameterProvider requestParams) {
        Object request = requestParams.getParameter(JSON_REQUEST_PARAM);
        JSONObject jsonRequest = null;
        if (request instanceof JSONObject) {
            jsonRequest = (JSONObject)request;
        } else if (request instanceof String) {
            try {
                jsonRequest = new JSONObject((String)request);
            }
            catch (JSONException e) {
                String msg = "Error deserializing JSON request '" + request + "'";
                try {
                    IOUtils.write((String)msg, (OutputStream)out, (String)CharsetHelper.getEncoding());
                }
                catch (IOException e1) {
                    // empty catch block
                }
                LogFactory.getLog(this.getClass()).error((Object)msg, (Throwable)e);
            }
        }
        try {
            JSONObject result = this.call(jsonRequest);
            IOUtils.write((String)result.toString(), (OutputStream)out, (String)CharsetHelper.getEncoding());
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)"", (Throwable)e);
        }
    }

    public abstract JSONObject call(JSONObject var1) throws Exception;
}

