/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import pt.webdetails.cpf.InterPluginCall;
import pt.webdetails.cpf.PentahoBasePluginEnvironment;
import pt.webdetails.cpf.PentahoUrlProvider;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.api.IContentAccessFactoryExtended;
import pt.webdetails.cpf.api.IUserContentAccessExtended;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.plugincall.api.IPluginCall;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.pentaho.unified.PluginRepositoryResourceAccess;
import pt.webdetails.cpf.repository.pentaho.unified.UserContentRepositoryAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class PentahoPluginEnvironment
extends PentahoBasePluginEnvironment
implements IContentAccessFactoryExtended {
    private static PentahoPluginEnvironment instance = new PentahoPluginEnvironment();
    private IUrlProvider pentahoUrlProvider;
    private static Log logger;

    protected PentahoPluginEnvironment() {
    }

    public static PentahoPluginEnvironment getInstance() {
        return instance;
    }

    @Override
    public IContentAccessFactoryExtended getContentAccessFactory() {
        return this;
    }

    @Override
    public IUserContentAccessExtended getUserContentAccess(String basePath) {
        return new UserContentRepositoryAccess(PentahoSessionHolder.getSession(), basePath);
    }

    public IReadAccess getPluginRepositoryReader(String basePath) {
        basePath = RepositoryHelper.appendPath((String)this.getPluginRepositoryDir(), (String)basePath);
        return new PluginRepositoryResourceAccess(basePath);
    }

    public IRWAccess getPluginRepositoryWriter(String basePath) {
        basePath = RepositoryHelper.appendPath((String)this.getPluginRepositoryDir(), (String)basePath);
        return new PluginRepositoryResourceAccess(basePath);
    }

    public IUrlProvider getUrlProvider() {
        if (this.pentahoUrlProvider == null) {
            this.pentahoUrlProvider = new PentahoUrlProvider(this.getPluginId());
        }
        return this.pentahoUrlProvider;
    }

    public IPluginCall getPluginCall(String pluginId, String servicePath, String method) {
        return new InterPluginCall(new InterPluginCall.Plugin(pluginId), servicePath, method);
    }

    static {
        PluginEnvironment.init((PluginEnvironment)instance);
        logger = LogFactory.getLog(PentahoPluginEnvironment.class);
        PluginEnvironment.init((PluginEnvironment)instance);
    }
}

