/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;

public class PentahoUrlProvider
implements IUrlProvider {
    private static final String REPOS = "api/repos/";
    private String pluginId;

    public PentahoUrlProvider(String id) {
        this.pluginId = id;
    }

    public String getPluginBaseUrl(String pluginId) {
        return Util.joinPath((String[])new String[]{this.getWebappContextPath(), "plugin", pluginId, "api"}) + "/";
    }

    public String getPluginBaseUrl() {
        return this.getPluginBaseUrl(this.pluginId);
    }

    public String getPluginStaticBaseUrl(String pluginId) {
        return Util.joinPath((String[])new String[]{this.getWebappContextPath(), REPOS, pluginId}) + "/";
    }

    public String getPluginStaticBaseUrl() {
        return this.getPluginStaticBaseUrl(this.pluginId);
    }

    public String getRepositoryUrl(String fullPath) {
        String colonPath = fullPath.replaceAll("/", ":");
        return Util.joinPath((String[])new String[]{this.getWebappContextPath(), REPOS, colonPath, "/content"});
    }

    public String getWebappContextPath() {
        return PentahoRequestContextHolder.getRequestContext().getContextPath();
    }

    public String getWebappContextRoot() {
        String url = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        String webappName = this.getWebappContextPath();
        return url.substring(0, url.length() - webappName.length() + 1);
    }

    public String getResourcesBasePath() {
        return "";
    }
}

