/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.pentaho;

import java.io.File;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.impl.FileBasedResourceAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class SystemPluginResourceAccess
extends FileBasedResourceAccess
implements IRWAccess {
    protected File basePath;

    public SystemPluginResourceAccess(ClassLoader classLoader, String basePath) {
        this.initPathFromClassLoader(classLoader, basePath);
    }

    public SystemPluginResourceAccess(String pluginId, String basePath) {
        IPluginManager pm = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        ClassLoader classLoader = pm.getClassLoader(pluginId);
        this.initPathFromClassLoader(classLoader, basePath);
    }

    private void initPathFromClassLoader(ClassLoader classLoader, String basePath) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Unknown plugin");
        }
        if (classLoader instanceof PluginClassLoader) {
            this.basePath = ((PluginClassLoader)classLoader).getPluginDir();
        } else {
            URL rootFileUrl = RepositoryHelper.getClosestResource((ClassLoader)classLoader, (String)"plugin.xml");
            if (rootFileUrl != null) {
                this.basePath = new File(rootFileUrl.getPath()).getParentFile();
            }
        }
        if (this.basePath == null) {
            throw new IllegalArgumentException("Couldn't find a valid base path from class loader");
        }
        if (!StringUtils.isEmpty((String)basePath)) {
            this.basePath = new File(this.basePath, basePath);
        }
    }

    protected File getFile(String path) {
        if (path != null && path.startsWith("/system/")) {
            String[] sections = path.split("/");
            String sysPluginDir = sections[1] + "/" + sections[2];
            String baseString = FilenameUtils.separatorsToUnix((String)this.basePath.toString());
            if (baseString.indexOf(sysPluginDir) != -1 && baseString.lastIndexOf(sysPluginDir) + sysPluginDir.length() == baseString.length()) {
                path = path.replaceFirst("/.*?/.*?/", "/");
            } else if (baseString.indexOf(sysPluginDir) == -1) {
                String systemPath = StringUtils.substringBeforeLast((String)this.basePath.getAbsolutePath(), (String)"system");
                systemPath = systemPath + sysPluginDir;
                path = path.replaceFirst("/.*?/.*?/", "/");
                return new File(systemPath, path);
            }
        }
        return StringUtils.isEmpty((String)path) ? this.basePath : new File(this.basePath, path);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(":").append(this.basePath);
        return sb.toString();
    }
}

