/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.audit;

import java.util.Iterator;
import java.util.UUID;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.AuditHelper;

public class CpfAuditHelper {
    public static UUID startAudit(String processId, String actionName, String objectName, IPentahoSession userSession, ILogger logger, IParameterProvider requestParams) {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        if (requestParams != null) {
            Iterator iter = requestParams.getParameterNames();
            while (iter.hasNext()) {
                String paramName = ((String)iter.next()).toString();
                sb.append(paramName).append("=").append(requestParams.getStringParameter(paramName, "novalue")).append(";");
            }
        }
        AuditHelper.audit((String)userSession.getId(), (String)userSession.getName(), (String)actionName, (String)objectName, (String)processId, (String)"instance_start", (String)uuid.toString(), (String)sb.toString(), (float)0.0f, (ILogger)logger);
        return uuid;
    }

    public static void endAudit(String processId, String actionName, String objectName, IPentahoSession userSession, ILogger logger, long start, UUID uuid, long end) {
        AuditHelper.audit((String)userSession.getId(), (String)userSession.getName(), (String)actionName, (String)objectName, (String)processId, (String)"instance_end", (String)uuid.toString(), (String)"", (float)((float)(end - start) / 1000.0f), (ILogger)logger);
    }
}

