/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.messaging;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.CpfProperties;
import pt.webdetails.cpf.InterPluginCall;
import pt.webdetails.cpf.JsonPluginCall;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.Result;
import pt.webdetails.cpf.messaging.IEventPublisher;
import pt.webdetails.cpf.messaging.PluginEvent;
import pt.webdetails.cpf.plugin.CorePlugin;

public class EventPublisher
implements IEventPublisher {
    protected static final long TIMEOUT = CpfProperties.getInstance().getLongProperty("messaging.publishTimeout", 11L);
    private static final boolean LOG_PUBLISH = false;
    private static Log logger = LogFactory.getLog(EventPublisher.class);
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(0, CpfProperties.getInstance().getIntProperty("messaging.maxThreads", 1), CpfProperties.getInstance().getLongProperty("messaging.publishTimeout", 11L), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(CpfProperties.getInstance().getIntProperty("messaging.queueSize", 3), true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private static Boolean cdvExists;

    public static synchronized boolean canPush() {
        if (cdvExists == null) {
            cdvExists = PluginEnvironment.env().getPluginCall(CorePlugin.CDV.getId(), null, "whatever").exists();
        }
        return cdvExists;
    }

    public static EventPublisher getPublisher() {
        return new EventPublisher();
    }

    public void publish(PluginEvent event) {
        if (!EventPublisher.canPush()) {
            logger.warn((Object)"publishToCDV: plugin not available, ignoring request");
            return;
        }
        FutureTask<Result> toRun = this.getPublishTask(event);
        executor.execute(toRun);
    }

    private Runnable getPublishAndLogTask(final PluginEvent event) {
        Runnable publishAndLog = new Runnable(){

            @Override
            public void run() {
                FutureTask toRun = EventPublisher.this.getPublishTask(event);
                try {
                    executor.execute(toRun);
                    Result result = (Result)toRun.get(TIMEOUT, TimeUnit.SECONDS);
                    String msg = "[" + event.getPlugin() + "] pushed event " + result;
                    switch (result.getStatus()) {
                        case OK: {
                            logger.info((Object)msg);
                            break;
                        }
                        case ERROR: {
                            logger.error((Object)msg);
                        }
                    }
                }
                catch (Exception e) {
                    toRun.cancel(true);
                    logger.error((Object)("push failed: timeout reached: " + TIMEOUT + " seconds"));
                }
            }
        };
        return publishAndLog;
    }

    private FutureTask<Result> getPublishTask(final PluginEvent event) {
        return new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                JsonPluginCall call = new JsonPluginCall(InterPluginCall.CDV, "warnings");
                return new Result(call.call(event.toJSON()));
            }
        });
    }
}

