/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import org.pentaho.chart.ChartBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.css.namespace.NamespaceDefinition;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ChartNamespaceDefinition
implements NamespaceDefinition {
    private ResourceKey chartStyleSheetKey;
    private String preferredPrefix;
    private String uri;
    private String[] classAttributeNames;
    private String[] styleAttributeNames;
    private static final String PREFERRED_PREFIX = "org.pentaho.chart.namespace.prefix";
    private static final String URI = "org.pentaho.chart.namespace.uri";
    private static final String CLASS_ATTRIBUTES = "org.pentaho.chart.namespace.class_attributes";
    private static final String STYLE_ATTRIBUTES = "org.pentaho.chart.namespace.style_attributes";
    private static final String CHART_STYLE_LOCATION = "org.pentaho.chart.namespace.style";
    private static final String DEFAULT_PREFERRED_PREFIX = "";
    private static final String DEFAULT_URI = "http://reporting.pentaho.org/namespaces/charting/1.0";
    private static final String DEFAULT_CLASS_ATTRIBUTE_NAMES = "class";
    private static final String DEFAULT_STYLE_ATTRIBUTE_NAMES = "style";
    private static final String DEFAULT_CHART_STYLE_LOCATION = "res://org/pentaho/chart/css/chart.css";

    public ChartNamespaceDefinition(ResourceManager resourceManager) throws ResourceKeyCreationException {
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        Configuration config = ChartBoot.getInstance().getGlobalConfig();
        this.preferredPrefix = config.getConfigProperty(PREFERRED_PREFIX, DEFAULT_PREFERRED_PREFIX);
        this.uri = config.getConfigProperty(URI, DEFAULT_URI);
        this.classAttributeNames = StringUtils.split((String)config.getConfigProperty(CLASS_ATTRIBUTES, DEFAULT_CLASS_ATTRIBUTE_NAMES));
        this.styleAttributeNames = StringUtils.split((String)config.getConfigProperty(STYLE_ATTRIBUTES, DEFAULT_STYLE_ATTRIBUTE_NAMES));
        String chartStyleLocation = config.getConfigProperty(CHART_STYLE_LOCATION, DEFAULT_CHART_STYLE_LOCATION);
        this.chartStyleSheetKey = resourceManager.createKey((Object)chartStyleLocation);
    }

    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }

    public String getURI() {
        return this.uri;
    }

    public String[] getClassAttribute(String element) {
        return (String[])this.classAttributeNames.clone();
    }

    public String[] getStyleAttribute(String element) {
        return (String[])this.styleAttributeNames.clone();
    }

    public ResourceKey getDefaultStyleSheetLocation() {
        return this.chartStyleSheetKey;
    }
}

