/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.core;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.Empty;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.css.dom.DefaultLayoutStyle;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;
import org.pentaho.util.collections.HeirarchicalLinkedListItem;

public class ChartElement
extends HeirarchicalLinkedListItem
implements Cloneable,
LayoutElement {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAMESPACE_ATTRIBUTE = "namespace";
    public static final String NAMESPACE = "http://reporting.pentaho.org/namespaces/charting/1.0";
    public static final String TAG_NAME_CHART = "chart";
    public static final String TAG_NAME_RANGE_LABEL = "rangeLabel";
    public static final String TAG_NAME_DOMAIN_LABEL = "domainLabel";
    public static final String TAG_NAME_STYLESHEET = "stylesheet";
    public static final String TAG_NAME_TITLE = "title";
    public static final String TAG_NAME_LEGEND = "legend";
    public static final String TAG_NAME_AXIS = "axis";
    public static final String TAG_NAME_PLOT = "plot";
    public static final String TAG_NAME_SERIES = "series";
    public static final String TAG_NAME_GROUP = "group";
    public static final String TAG_NAME_LABEL = "label";
    public static final String TAG_NAME_TICK_LABEL = "ticklabel";
    public static final String CATEGORICAL = "categorical";
    public static final String BYROW = "byrow";
    public static final String ID = "id";
    public static final String HREF = "href";
    public static final String COLUMN_POSITION = "column-pos";
    public static final String ROW_POSITION = "row-pos";
    public static final String COLUMN_NAME = "column-name";
    public static final String STACKED = "stacked";
    private AttributeMap attributes = new AttributeMap();
    private String tagName;
    private String text;
    private final DefaultLayoutStyle layoutStyle;
    private static final String TO_STRING_PREFIX = "  ";

    public ChartElement() {
        this.setNamespace(NAMESPACE);
        this.layoutStyle = new DefaultLayoutStyle();
        this.markModified();
    }

    public boolean isStyleResolved() {
        return !this.layoutStyle.isEmpty();
    }

    public String getNamespace() {
        return (String)this.getAttribute(NAMESPACE, NAMESPACE_ATTRIBUTE);
    }

    public void setNamespace(String id) {
        this.setAttribute(NAMESPACE, NAMESPACE_ATTRIBUTE, id);
        this.markModified();
    }

    public String getId() {
        return (String)this.getAttribute(NAMESPACE, "id");
    }

    public void setId(String id) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", "id", id);
        this.markModified();
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        if (StringUtils.isEmpty((String)tagName)) {
            throw new NullPointerException();
        }
        this.tagName = tagName.trim();
        this.markModified();
    }

    public void setName(String name) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", NAME_ATTRIBUTE, name);
        this.markModified();
    }

    public String getName() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", NAME_ATTRIBUTE);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(this.getNamespace(), name, value);
        this.markModified();
    }

    public void setAttribute(String namespace, String name, Object value) {
        if (StringUtils.isEmpty((String)name)) {
            throw new NullPointerException();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        this.attributes.setAttribute(namespace, name.trim(), value);
        this.markModified();
    }

    public Object getAttribute(String name) {
        return this.getAttribute(this.getNamespace(), name);
    }

    public Object getAttribute(String namespace, String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(namespace, name);
    }

    public Map getAttributes(String namespace) {
        if (this.attributes == null) {
            return Empty.MAP;
        }
        return this.attributes.getAttributes(namespace);
    }

    public AttributeMap getAttributeMap() {
        return new AttributeMap(this.attributes);
    }

    public String[] getAttributeNameSpaces() {
        if (this.attributes == null) {
            return Empty.STRING_ARRAY;
        }
        return this.attributes.getNameSpaces();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChartElement element = (ChartElement)super.clone();
        if (this.attributes != null) {
            element.attributes = this.attributes.clone();
        }
        return element;
    }

    public Map getCounters() {
        return Empty.MAP;
    }

    public Locale getLanguage() {
        return Locale.getDefault();
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    public String getPseudoElement() {
        return null;
    }

    public Map getStrings() {
        return Empty.MAP;
    }

    public boolean isPseudoElement() {
        return false;
    }

    public LayoutElement getPreviousLayoutElement() {
        return this.getPreviousItem();
    }

    public LayoutElement getParentLayoutElement() {
        return this.getParentItem();
    }

    public void addChildElement(ChartElement chartElement) {
        this.addChildItem(chartElement);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.markModified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("tagName=[").append(this.tagName).append("]");
        sb.append(" attributes=[").append(this.attributes).append("]");
        if (this.text != null) {
            sb.append(" text=[").append(this.text).append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append(this.toString()).append("\n");
        for (ChartElement child = this.getFirstChildItem(); child != null; child = child.getNextItem()) {
            sb.append("\n").append(child.toString(prefix + TO_STRING_PREFIX));
        }
        return sb.toString();
    }

    @Override
    public ChartElement getParentItem() {
        return (ChartElement)super.getParentItem();
    }

    @Override
    public ChartElement getPreviousItem() {
        return (ChartElement)super.getPreviousItem();
    }

    @Override
    public ChartElement getNextItem() {
        return (ChartElement)super.getNextItem();
    }

    @Override
    public ChartElement getFirstChildItem() {
        return (ChartElement)super.getFirstChildItem();
    }

    @Override
    public ChartElement getLastChildItem() {
        return (ChartElement)super.getLastChildItem();
    }

    @Override
    public ChartElement getNextDepthFirstItem() {
        return (ChartElement)super.getNextDepthFirstItem();
    }

    public ChartElement[] findChildrenByName(String tagNameToMatch) {
        ArrayList<ChartElement> matchList = new ArrayList<ChartElement>();
        if (tagNameToMatch != null) {
            for (ChartElement item = this.getFirstChildItem(); item != null; item = item.getNextItem()) {
                if (!tagNameToMatch.equals(item.getTagName())) continue;
                matchList.add(item);
            }
        }
        return matchList.toArray(new ChartElement[matchList.size()]);
    }

    public CSSValue getStyle(StyleKey key) {
        CSSValue result = null;
        if (key != null) {
            result = this.getLayoutStyle().getValue(key);
        }
        return result;
    }
}

