/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.data.IScalableDataModel;
import org.pentaho.chart.data.NamedValue;
import org.pentaho.chart.data.NamedValuesDataModel;

public class MultiSeriesDataModel
implements IChartDataModel,
IScalableDataModel {
    LinkedHashMap<String, NamedValuesDataModel> chartData = new LinkedHashMap();
    Number scalingFactor = 1;

    public void addValue(String categoryName, String seriesName, Number value) {
        NamedValue existingDataPoint;
        NamedValuesDataModel namedValueDataModel = this.chartData.get(categoryName);
        if (namedValueDataModel == null) {
            namedValueDataModel = new NamedValuesDataModel();
            if (this.chartData.size() > 0) {
                for (NamedValue existingDataPoint2 : this.chartData.values().iterator().next()) {
                    namedValueDataModel.add(new NamedValue(existingDataPoint2.getName(), null));
                }
            }
            this.chartData.put(categoryName, namedValueDataModel);
        }
        if ((existingDataPoint = namedValueDataModel.getNamedValue(seriesName)) == null) {
            namedValueDataModel.add(new NamedValue(seriesName.toString(), value));
            for (String tmpCategory : this.chartData.keySet()) {
                if (categoryName.equals(tmpCategory)) continue;
                this.chartData.get(tmpCategory).add(new NamedValue(seriesName.toString(), null));
            }
        } else if (existingDataPoint.getValue() == null) {
            existingDataPoint.setValue(value);
        } else if (value != null) {
            existingDataPoint.setValue(existingDataPoint.getValue().doubleValue() + value.doubleValue());
        }
    }

    public DomainData getDomainData(String domainName) {
        DomainData domainData = null;
        NamedValuesDataModel namedValueDataModel = this.chartData.get(domainName);
        if (namedValueDataModel != null) {
            domainData = new DomainData(domainName);
            domainData.addAll(namedValueDataModel);
        }
        return domainData;
    }

    public List<DomainData> getDomainData() {
        ArrayList<DomainData> domainData = new ArrayList<DomainData>();
        for (Map.Entry<String, NamedValuesDataModel> mapEntry : this.chartData.entrySet()) {
            DomainData domain = new DomainData(mapEntry.getKey());
            domain.addAll(mapEntry.getValue());
            domainData.add(domain);
        }
        return domainData;
    }

    public SeriesData getSeriesData(String seriesName) {
        SeriesData seriesData = null;
        if (this.chartData.size() > 0 && this.chartData.values().iterator().next().getNames().contains(seriesName)) {
            seriesData = new SeriesData(seriesName);
            for (Map.Entry<String, NamedValuesDataModel> mapEntry : this.chartData.entrySet()) {
                String domainName = mapEntry.getKey();
                Number value = mapEntry.getValue().getNamedValue((String)seriesName).value;
                seriesData.add(new NamedValue(domainName, value));
            }
        }
        return seriesData;
    }

    public List<SeriesData> getSeriesData() {
        ArrayList<SeriesData> seriesList = new ArrayList<SeriesData>();
        ArrayList<String> seriesNames = new ArrayList<String>();
        if (this.chartData.size() > 0) {
            seriesNames.addAll(this.chartData.values().iterator().next().getNames());
        }
        for (String seriesName : seriesNames) {
            SeriesData series = new SeriesData(seriesName);
            for (Map.Entry<String, NamedValuesDataModel> mapEntry : this.chartData.entrySet()) {
                String domainName = mapEntry.getKey();
                Number value = mapEntry.getValue().getNamedValue((String)seriesName).value;
                series.add(new NamedValue(domainName, value));
            }
            seriesList.add(series);
        }
        return seriesList;
    }

    @Override
    public Number getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public void setScalingFactor(Number scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public class DomainData
    extends NamedValuesDataModel {
        String domainName;

        DomainData() {
        }

        DomainData(String domainName) {
            this.domainName = domainName;
        }

        public List<String> getSeries() {
            return this.getNames();
        }

        public String getDomainName() {
            return this.domainName;
        }

        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }
    }

    public class SeriesData
    extends NamedValuesDataModel {
        String seriesName;

        SeriesData() {
        }

        SeriesData(String seriesName) {
            this.seriesName = seriesName;
        }

        public List<String> getDomains() {
            return this.getNames();
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public void setSeriesName(String seriesName) {
            this.seriesName = seriesName;
        }
    }
}

