/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.chart.model.ChartLegend;
import org.pentaho.chart.model.ChartTitle;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.Gradient;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.StyledText;
import org.pentaho.chart.model.Texture;
import org.pentaho.chart.model.Theme;

public class ChartModel
implements Serializable {
    public static final String DEFAULT_FAMILY = "serif";
    public static final int DEFAULT_SIZE = 14;
    ChartTitle title = new ChartTitle();
    ArrayList<StyledText> subtitles = new ArrayList();
    ChartLegend legend = new ChartLegend();
    String backgroundImageLocation;
    Texture backgroundTexture;
    Gradient backgroundGradient;
    Plot plot;
    String chartEngineId;
    Theme.ChartTheme theme;
    CssStyle style = new CssStyle();

    public String getChartEngineId() {
        return this.chartEngineId;
    }

    public void setChartEngineId(String id) {
        this.chartEngineId = id;
    }

    public Theme.ChartTheme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme.ChartTheme theme) {
        this.theme = theme;
    }

    public List<StyledText> getSubtitles() {
        return this.subtitles;
    }

    public void setSubtitles(List<StyledText> subtitles) {
        subtitles.clear();
        if (subtitles != null) {
            subtitles.addAll(subtitles);
        }
    }

    public StyledText getSubtitle() {
        return this.subtitles.size() > 0 ? this.subtitles.get(0) : null;
    }

    public void setSubtitle(StyledText title) {
        this.subtitles.clear();
        if (title != null) {
            this.subtitles.add(title);
        }
    }

    public ChartLegend getLegend() {
        return this.legend;
    }

    public void setLegend(ChartLegend chartLegend) {
        this.legend = chartLegend;
    }

    public Object getBackground() {
        Object background = null;
        if (this.style.getBackgroundColor() != null) {
            background = this.style.getBackgroundColor();
        } else if (this.backgroundGradient != null) {
            background = this.backgroundGradient;
        } else if (this.backgroundImageLocation != null) {
            background = this.backgroundImageLocation;
        } else if (this.backgroundTexture != null) {
            background = this.backgroundTexture;
        }
        return background;
    }

    public void setBackground(Integer backgroundColor) {
        this.style.setBackgroundColor(backgroundColor);
        if (backgroundColor != null) {
            this.backgroundGradient = null;
            this.backgroundImageLocation = null;
            this.backgroundTexture = null;
        }
    }

    public void setBackground(String backgroundImageLocation) {
        this.backgroundImageLocation = backgroundImageLocation;
        if (backgroundImageLocation != null) {
            this.backgroundGradient = null;
            this.setBackground((Integer)null);
            this.backgroundTexture = null;
        }
    }

    public void setBackground(Gradient backgroundGradient) {
        this.backgroundGradient = backgroundGradient;
        if (backgroundGradient != null) {
            this.setBackground((Integer)null);
            this.backgroundImageLocation = null;
            this.backgroundTexture = null;
        }
    }

    public void setBackground(Texture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        if (backgroundTexture != null) {
            this.backgroundGradient = null;
            this.setBackground((Integer)null);
            this.backgroundImageLocation = null;
        }
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public ChartTitle getTitle() {
        return this.title;
    }

    public void setTitle(ChartTitle title) {
        this.title = title;
    }

    public Integer getBorderColor() {
        return this.style.getBorderColor();
    }

    public boolean getBorderVisible() {
        return this.style.getBorderVisible();
    }

    public Integer getBorderWidth() {
        return this.style.getBorderWidth();
    }

    public void setBorderColor(Integer color) {
        this.style.setBorderColor(color);
    }

    public void setBorderVisible(boolean visible) {
        this.style.setBorderVisible(visible);
    }

    public void setBorderWidth(Integer width) {
        this.style.setBorderWidth(width);
    }

    public CssStyle getStyle() {
        return this.style;
    }
}

