/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeSet;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.StyledText;

public class DialPlot
extends Plot
implements Serializable {
    Scale scale = new Scale();
    StyledText annotation = new StyledText();
    boolean animate = false;

    public DialPlot() {
        this.setPalette(null);
    }

    public Scale getScale() {
        return this.scale;
    }

    public StyledText getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(StyledText annotation) {
        this.annotation = annotation;
    }

    public boolean getAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public static class DialRange
    implements Serializable,
    Comparable<DialRange> {
        CssStyle style = new CssStyle();
        Number minValue = 0;
        Number maxValue = 0;

        public DialRange() {
        }

        public DialRange(Number minValue, Number maxValue) {
            this(minValue, maxValue, null);
        }

        public DialRange(Number minValue, Number maxValue, Integer color) {
            this.setRange(minValue, maxValue);
            if (color != null) {
                this.setColor(color);
            }
        }

        public CssStyle getStyle() {
            return this.style;
        }

        public Integer getColor() {
            return this.style.getColor();
        }

        public void setColor(Integer color) {
            this.style.setColor(color);
        }

        public void setRange(Number minValue, Number maxValue) {
            if (minValue.doubleValue() >= maxValue.doubleValue()) {
                this.setMinValue(maxValue);
                this.setMaxValue(minValue);
            } else {
                this.setMinValue(minValue);
                this.setMaxValue(maxValue);
            }
        }

        public Number getMinValue() {
            return this.minValue;
        }

        public void setMinValue(Number minValue) {
            this.minValue = minValue;
        }

        public Number getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(Number maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public int compareTo(DialRange o) {
            double thatValue;
            int comparison = 0;
            double thisValue = this.minValue.doubleValue();
            if (thisValue < (thatValue = o.minValue.doubleValue())) {
                comparison = -1;
            } else if (thisValue > thatValue) {
                comparison = 1;
            }
            if (comparison == 0) {
                thisValue = this.maxValue.doubleValue();
                if (thisValue < (thatValue = o.maxValue.doubleValue())) {
                    comparison = -1;
                } else if (thisValue > thatValue) {
                    comparison = 1;
                }
            }
            return comparison;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof DialRange) {
                DialRange otherRange = (DialRange)obj;
                result = this.minValue.equals(otherRange.minValue) && this.maxValue.equals(otherRange.maxValue);
            }
            return result;
        }
    }

    public static class Scale
    extends ArrayList<DialRange> {
        public Number getMinValue() {
            Number minValue = new Integer(0);
            if (this.size() > 0) {
                minValue = ((DialRange)this.get((int)0)).minValue;
            }
            return minValue;
        }

        public Number getMaxValue() {
            Number maxValue = new Integer(0);
            if (this.size() > 0) {
                maxValue = ((DialRange)this.get((int)(this.size() - 1))).maxValue;
            }
            return maxValue;
        }

        public void addRange(DialRange dialRange) {
            if (!this.contains(dialRange)) {
                TreeSet<DialRange> ranges = new TreeSet<DialRange>(this);
                ranges.add(dialRange);
                this.clear();
                this.addAll(ranges);
                int index = this.indexOf(dialRange);
                if (index > 0 && ((DialRange)this.get(index - 1)).getMaxValue().doubleValue() > dialRange.getMinValue().doubleValue()) {
                    ((DialRange)this.get(index - 1)).setMaxValue(dialRange.getMinValue());
                }
                if (index < this.size() - 1 && ((DialRange)this.get(index + 1)).getMinValue().doubleValue() < dialRange.getMaxValue().doubleValue()) {
                    ((DialRange)this.get(index + 1)).setMinValue(dialRange.getMaxValue());
                }
            }
        }

        public void removeRange(DialRange dialRange) {
            this.remove(dialRange);
        }
    }
}

