/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.chart.ChartBoot;
import org.pentaho.chart.plugin.ChartProcessingException;
import org.pentaho.chart.plugin.IChartPlugin;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ChartPluginFactory {
    private static final Log logger = LogFactory.getLog(ChartPluginFactory.class);

    private ChartPluginFactory() {
    }

    public static synchronized IChartPlugin getInstance() throws ChartProcessingException {
        return ChartPluginFactory.getInstance(null);
    }

    public static IChartPlugin getInstance(String className) throws ChartProcessingException {
        Configuration config;
        if (className == null && (className = (config = ChartBoot.getInstance().loadConfiguration()).getConfigProperty("org.pentaho.chart.plugin.Default-IChartPlugin")) == null) {
            throw new ChartProcessingException("No ChartPlugin defined as default");
        }
        try {
            IChartPlugin o = (IChartPlugin)ObjectUtilities.loadAndInstantiate((String)className, ChartPluginFactory.class, IChartPlugin.class);
            if (o == null) {
                throw new ChartProcessingException("Unable to instantiate the requested chart-plugin: " + className);
            }
            return o;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ChartProcessingException("Error while instantiating the Chart-Plugin " + className, e);
        }
    }
}

