/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.ChartUtils;
import org.pentaho.chart.IChartLinkGenerator;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartSeriesType;
import org.pentaho.chart.data.BasicDataModel;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.data.MultiSeriesDataModel;
import org.pentaho.chart.data.MultiSeriesXYDataModel;
import org.pentaho.chart.data.NamedValue;
import org.pentaho.chart.data.NamedValuesDataModel;
import org.pentaho.chart.data.XYDataModel;
import org.pentaho.chart.data.XYDataPoint;
import org.pentaho.chart.model.AreaPlot;
import org.pentaho.chart.model.Axis;
import org.pentaho.chart.model.BarPlot;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.DialPlot;
import org.pentaho.chart.model.Grid;
import org.pentaho.chart.model.LinePlot;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.ScatterPlot;
import org.pentaho.chart.model.StyledText;
import org.pentaho.chart.model.TwoAxisPlot;
import org.pentaho.chart.plugin.api.ChartResult;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.jfreechart.chart.area.JFreeAreaChartGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.chart.bar.JFreeBarChartGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.chart.dial.JFreeDialChartGenerator;
import org.pentaho.chart.plugin.jfreechart.chart.dial.JFreeDialChartGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.chart.line.JFreeLineChartGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.chart.multi.JFreeMultiChartGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.chart.pie.JFreePieChartGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.outputs.JFreeChartOutput;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.util.messages.Messages;

public class JFreeChartFactoryEngine
implements Serializable {
    private static final Log logger = LogFactory.getLog(JFreeChartFactoryEngine.class);
    private static final long serialVersionUID = -1079376910255750394L;

    public IOutput makeChart(ChartModel chartModel, IChartDataModel chartTableModel) {
        return this.makeChart(chartModel, chartTableModel, null);
    }

    public IOutput makeChart(ChartModel chartModel, IChartDataModel chartDataModel, IChartLinkGenerator linkGenerator) {
        JFreeChartOutput chartOutput = null;
        if (chartModel.getPlot() instanceof BarPlot) {
            chartOutput = new JFreeChartOutput(this.makeBarChart(chartModel, (MultiSeriesDataModel)chartDataModel, linkGenerator));
        } else if (chartModel.getPlot() instanceof LinePlot) {
            chartOutput = new JFreeChartOutput(this.makeLineChart(chartModel, (MultiSeriesDataModel)chartDataModel, linkGenerator));
        } else if (chartModel.getPlot() instanceof AreaPlot) {
            chartOutput = new JFreeChartOutput(this.makeAreaChart(chartModel, (MultiSeriesDataModel)chartDataModel, linkGenerator));
        } else if (chartModel.getPlot() instanceof DialPlot) {
            chartOutput = new JFreeChartOutput(this.makeDialChart(chartModel, (BasicDataModel)chartDataModel));
        } else if (chartModel.getPlot() instanceof org.pentaho.chart.model.PiePlot) {
            chartOutput = new JFreeChartOutput(this.makePieChart(chartModel, (NamedValuesDataModel)chartDataModel, linkGenerator));
        } else if (chartModel.getPlot() instanceof ScatterPlot) {
            chartOutput = chartDataModel instanceof MultiSeriesXYDataModel ? new JFreeChartOutput(this.makeScatterChart(chartModel, (MultiSeriesXYDataModel)chartDataModel)) : new JFreeChartOutput(this.makeScatterChart(chartModel, (XYDataModel)chartDataModel));
        }
        return chartOutput;
    }

    public JFreeChart makePieChart(ChartModel chartModel, NamedValuesDataModel dataModel, final IChartLinkGenerator linkGenerator) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (NamedValue namedValue : dataModel) {
            if (namedValue.getName() == null) continue;
            dataset.setValue((Comparable)((Object)namedValue.getName()), this.scaleNumber(namedValue.getValue(), dataModel.getScalingFactor()));
        }
        boolean showLegend = chartModel.getLegend() != null && chartModel.getLegend().getVisible();
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)showLegend, (boolean)true, (boolean)false);
        this.initChart(chart, chartModel);
        PiePlot jFreePiePlot = (PiePlot)chart.getPlot();
        if (linkGenerator != null) {
            jFreePiePlot.setURLGenerator(new PieURLGenerator(){

                public String generateURL(PieDataset arg0, Comparable arg1, int arg2) {
                    return linkGenerator.generateLink(arg1.toString(), arg1.toString(), arg0.getValue(arg1));
                }
            });
        }
        jFreePiePlot.setNoDataMessage("No data available");
        jFreePiePlot.setCircular(true);
        jFreePiePlot.setLabelGap(0.02);
        org.pentaho.chart.model.PiePlot chartBeansPiePlot = (org.pentaho.chart.model.PiePlot)chartModel.getPlot();
        List<Integer> colors = this.getPlotColors(chartBeansPiePlot);
        int index = 0;
        for (NamedValue namedValue : dataModel) {
            if (namedValue.getName() != null) {
                jFreePiePlot.setSectionPaint((Comparable)((Object)namedValue.getName()), (Paint)new Color(0xFFFFFF & colors.get(index % colors.size())));
            }
            ++index;
        }
        if (chartBeansPiePlot.getLabels().getVisible()) {
            jFreePiePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
            Font font = ChartUtils.getFont(chartBeansPiePlot.getLabels().getFontFamily(), chartBeansPiePlot.getLabels().getFontStyle(), chartBeansPiePlot.getLabels().getFontWeight(), chartBeansPiePlot.getLabels().getFontSize());
            if (font != null) {
                jFreePiePlot.setLabelFont(font);
                if (chartBeansPiePlot.getLabels().getColor() != null) {
                    jFreePiePlot.setLabelPaint((Paint)new Color(0xFFFFFF & chartBeansPiePlot.getLabels().getColor()));
                }
                if (chartBeansPiePlot.getLabels().getBackgroundColor() != null) {
                    jFreePiePlot.setLabelBackgroundPaint((Paint)new Color(0xFFFFFF & chartBeansPiePlot.getLabels().getBackgroundColor()));
                }
            }
        } else {
            jFreePiePlot.setLabelGenerator(null);
        }
        jFreePiePlot.setStartAngle((double)(-chartBeansPiePlot.getStartAngle().intValue()));
        return chart;
    }

    protected JFreeChart makeDialChart(ChartModel chartModel, BasicDataModel data) {
        DialPlot chartBeansDialPlot = (DialPlot)chartModel.getPlot();
        JFreeDialChartGenerator.SquareDialPlot jFreeDialPlot = new JFreeDialChartGenerator.SquareDialPlot();
        DefaultValueDataset dataset = new DefaultValueDataset();
        dataset.setValue(this.scaleNumber(data.getData().get(0), data.getScalingFactor()));
        jFreeDialPlot.setDataset((ValueDataset)dataset);
        JFreeDialChartGenerator.DoubleLineDialFrame dialFrame = new JFreeDialChartGenerator.DoubleLineDialFrame();
        dialFrame.setForegroundPaint(new Color(0x8D8D8D));
        dialFrame.setInnerForegroundPaint(new Color(0x5D5D5D));
        dialFrame.setStroke(new BasicStroke(2.0f));
        dialFrame.setBackgroundPaint(Color.WHITE);
        jFreeDialPlot.setDialFrame((DialFrame)dialFrame);
        for (DialPlot.DialRange dialRange : chartBeansDialPlot.getScale()) {
            if (dialRange.getColor() == null) continue;
            JFreeDialChartGenerator.SingleLineDialRange standarddialrange = new JFreeDialChartGenerator.SingleLineDialRange(dialRange.getMinValue().doubleValue(), dialRange.getMaxValue().doubleValue(), new Color(0xFFFFFF & dialRange.getColor()));
            standarddialrange.setInnerRadius(0.4);
            jFreeDialPlot.addLayer((DialLayer)standarddialrange);
        }
        double scaleMajorTickIncrement = (chartBeansDialPlot.getScale().getMaxValue().doubleValue() - chartBeansDialPlot.getScale().getMinValue().doubleValue()) / 5.0;
        JFreeDialChartGenerator.FixedStandardDialScale standardDialScale = new JFreeDialChartGenerator.FixedStandardDialScale(chartBeansDialPlot.getScale().getMinValue().doubleValue(), chartBeansDialPlot.getScale().getMaxValue().doubleValue(), -150.0, -240.0, scaleMajorTickIncrement, 2);
        standardDialScale.setTickRadius(0.88);
        standardDialScale.setTickLabelOffset(0.15);
        standardDialScale.setTickLabelFont(ChartUtils.getFont("sans-serif", CssStyle.FontStyle.NORMAL, CssStyle.FontWeight.NORMAL, 10));
        standardDialScale.setTickLabelPaint(Color.BLACK);
        standardDialScale.setMajorTickLength(0.04);
        standardDialScale.setMajorTickPaint(Color.BLACK);
        standardDialScale.setMajorTickStroke(new BasicStroke(2.0f));
        standardDialScale.setMinorTickLength(0.02);
        standardDialScale.setMinorTickPaint(new Color(0x8B8B8B));
        standardDialScale.setMinorTickStroke(new BasicStroke(1.0f));
        jFreeDialPlot.addScale(0, (DialScale)standardDialScale);
        DialCap dialCap = new DialCap();
        dialCap.setRadius(0.06);
        dialCap.setFillPaint((Paint)new Color(0x636363));
        dialCap.setOutlinePaint((Paint)new Color(0x5D5D5D));
        dialCap.setOutlineStroke((Stroke)new BasicStroke(2.0f));
        jFreeDialPlot.setCap((DialLayer)dialCap);
        GradientPaint gradientpaint = new GradientPaint(new Point(), new Color(0xFCFCFC), new Point(), new Color(14145754));
        DialBackground dialbackground = new DialBackground((Paint)gradientpaint);
        dialbackground.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        jFreeDialPlot.setBackground((DialLayer)dialbackground);
        JFreeDialChartGenerator.VariableStrokePointer pointer = new JFreeDialChartGenerator.VariableStrokePointer();
        pointer.setRadius(0.9);
        pointer.setOutlineStroke(new BasicStroke(2.0f));
        pointer.setWidthRadius(0.05);
        pointer.setFillPaint(new Color(0x636363));
        pointer.setOutlinePaint(new Color(0x5D5D5D));
        jFreeDialPlot.addPointer((DialPointer)pointer);
        DialValueIndicator dialValueIndicator = new DialValueIndicator(0);
        dialValueIndicator.setTemplateValue(chartBeansDialPlot.getScale().getMaxValue());
        dialValueIndicator.setFont(ChartUtils.getFont("Dialog", CssStyle.FontStyle.NORMAL, CssStyle.FontWeight.BOLD, 10));
        dialValueIndicator.setPaint((Paint)Color.BLACK);
        dialValueIndicator.setBackgroundPaint((Paint)Color.WHITE);
        dialValueIndicator.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        dialValueIndicator.setOutlinePaint((Paint)new Color(0x8B8B8B));
        jFreeDialPlot.addLayer((DialLayer)dialValueIndicator);
        if (chartBeansDialPlot.getAnnotation() != null && chartBeansDialPlot.getAnnotation().getText() != null && chartBeansDialPlot.getAnnotation().getText().trim().length() > 0) {
            Font font = ChartUtils.getFont(chartBeansDialPlot.getAnnotation().getFontFamily(), chartBeansDialPlot.getAnnotation().getFontStyle(), chartBeansDialPlot.getAnnotation().getFontWeight(), chartBeansDialPlot.getAnnotation().getFontSize());
            if (font == null) {
                font = ChartUtils.getFont("sans-serif", CssStyle.FontStyle.NORMAL, CssStyle.FontWeight.NORMAL, 10);
            }
            DialTextAnnotation dialTextAnnotation = new DialTextAnnotation(chartBeansDialPlot.getAnnotation().getText().trim());
            dialTextAnnotation.setFont(font);
            dialTextAnnotation.setRadius(0.6);
            jFreeDialPlot.addLayer((DialLayer)dialTextAnnotation);
        }
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        JFreeChart chart = new JFreeChart(title, (Plot)jFreeDialPlot);
        this.initChart(chart, chartModel);
        return chart;
    }

    protected void initChart(JFreeChart chart, ChartModel chartModel) {
        Font font;
        if (chartModel.getBackground() instanceof Integer) {
            chart.setBackgroundPaint((Paint)new Color(0xFFFFFF & (Integer)chartModel.getBackground()));
        } else {
            chart.setBackgroundPaint((Paint)Color.WHITE);
        }
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            font = ChartUtils.getFont(chartModel.getTitle().getFontFamily(), chartModel.getTitle().getFontStyle(), chartModel.getTitle().getFontWeight(), chartModel.getTitle().getFontSize());
            if (font != null) {
                chart.getTitle().setFont(font);
            }
            RectangleEdge rectangleEdge = RectangleEdge.TOP;
            if (chartModel.getTitle().getLocation() != null) {
                switch (chartModel.getTitle().getLocation()) {
                    case RIGHT: {
                        rectangleEdge = RectangleEdge.BOTTOM;
                        break;
                    }
                    case LEFT: {
                        rectangleEdge = RectangleEdge.LEFT;
                        break;
                    }
                    case BOTTOM: {
                        rectangleEdge = RectangleEdge.BOTTOM;
                    }
                }
            }
            chart.getTitle().setPosition(rectangleEdge);
            if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
                HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
                if (chartModel.getTitle().getAlignment() != null) {
                    switch (chartModel.getTitle().getAlignment()) {
                        case LEFT: {
                            horizontalAlignment = HorizontalAlignment.LEFT;
                            break;
                        }
                        case RIGHT: {
                            horizontalAlignment = HorizontalAlignment.RIGHT;
                        }
                    }
                }
                chart.getTitle().setHorizontalAlignment(horizontalAlignment);
            }
        }
        if (chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
            font = ChartUtils.getFont(chartModel.getLegend().getFontFamily(), chartModel.getLegend().getFontStyle(), chartModel.getLegend().getFontWeight(), chartModel.getLegend().getFontSize());
            if (font != null) {
                chart.getLegend().setItemFont(font);
            }
            if (!chartModel.getLegend().getBorderVisible()) {
                chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            }
        }
        chart.setBorderVisible(chartModel.getBorderVisible());
        if (chartModel.getBorderColor() instanceof Integer) {
            chart.setBorderPaint((Paint)new Color(0xFFFFFF & chartModel.getBorderColor()));
        }
        for (StyledText subtitle : chartModel.getSubtitles()) {
            if (subtitle.getText() == null || subtitle.getText().trim().length() <= 0) continue;
            TextTitle textTitle = new TextTitle(subtitle.getText());
            Font font2 = ChartUtils.getFont(subtitle.getFontFamily(), subtitle.getFontStyle(), subtitle.getFontWeight(), subtitle.getFontSize());
            if (font2 != null) {
                textTitle.setFont(font2);
            }
            if (subtitle.getColor() != null) {
                textTitle.setPaint((Paint)new Color(0xFFFFFF & subtitle.getColor()));
            }
            if (subtitle.getBackgroundColor() != null) {
                textTitle.setBackgroundPaint((Paint)new Color(0xFFFFFF & subtitle.getBackgroundColor()));
            }
            chart.addSubtitle((Title)textTitle);
        }
    }

    public JFreeChart makeAreaChart(ChartModel chartModel, MultiSeriesDataModel dataModel, IChartLinkGenerator linkGenerator) {
        DefaultCategoryDataset categoryDataset = this.createCategoryDataset(dataModel);
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        PlotOrientation plotOrientation = twoAxisPlot.getOrientation() == Plot.Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        boolean showLegend = chartModel.getLegend() != null && chartModel.getLegend().getVisible();
        JFreeChart chart = ChartFactory.createAreaChart((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false);
        this.initCategoryPlot(chart, chartModel, linkGenerator);
        this.initChart(chart, chartModel);
        return chart;
    }

    public JFreeChart makeLineChart(ChartModel chartModel, MultiSeriesDataModel dataModel, IChartLinkGenerator linkGenerator) {
        DefaultCategoryDataset categoryDataset = this.createCategoryDataset(dataModel);
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        PlotOrientation plotOrientation = twoAxisPlot.getOrientation() == Plot.Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        boolean showLegend = chartModel.getLegend() != null && chartModel.getLegend().getVisible();
        JFreeChart chart = null;
        LinePlot linePlot = (LinePlot)twoAxisPlot;
        if (linePlot.getFlavor() == LinePlot.LinePlotFlavor.THREED) {
            chart = ChartFactory.createLineChart3D((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false);
        } else {
            chart = ChartFactory.createLineChart((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false);
            Stroke stroke = this.getLineStyleStroke(linePlot.getFlavor(), linePlot.getLineWidth());
            ((CategoryPlot)chart.getPlot()).getRenderer().setStroke(stroke);
        }
        this.initCategoryPlot(chart, chartModel, linkGenerator);
        this.initChart(chart, chartModel);
        return chart;
    }

    private XYSeries createXYSeries(XYDataModel xyDataModel) {
        XYSeries series = null;
        series = xyDataModel instanceof MultiSeriesXYDataModel.Series ? new XYSeries((Comparable)((Object)((MultiSeriesXYDataModel.Series)xyDataModel).getSeriesName())) : new XYSeries((Comparable)((Object)""));
        for (XYDataPoint dataPoint : xyDataModel) {
            series.add(dataPoint.getDomainValue(), dataPoint.getRangeValue());
        }
        return series;
    }

    protected JFreeChart makeScatterChart(ChartModel chartModel, XYDataModel data) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(this.createXYSeries(data));
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        PlotOrientation plotOrientation = twoAxisPlot.getOrientation() == Plot.Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        boolean showLegend = chartModel.getLegend() != null && chartModel.getLegend().getVisible();
        JFreeChart chart = ChartFactory.createScatterPlot((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false);
        this.initXYPlot(chart, chartModel);
        this.initChart(chart, chartModel);
        return chart;
    }

    protected JFreeChart makeScatterChart(ChartModel chartModel, MultiSeriesXYDataModel data) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (MultiSeriesXYDataModel.Series series : data.getSeries()) {
            dataset.addSeries(this.createXYSeries(series));
        }
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        PlotOrientation plotOrientation = twoAxisPlot.getOrientation() == Plot.Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        boolean showLegend = chartModel.getLegend() != null && chartModel.getLegend().getVisible();
        JFreeChart chart = ChartFactory.createScatterPlot((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false);
        this.initXYPlot(chart, chartModel);
        this.initChart(chart, chartModel);
        return chart;
    }

    protected DefaultCategoryDataset createCategoryDataset(MultiSeriesDataModel data) {
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        for (MultiSeriesDataModel.DomainData category : data.getDomainData()) {
            for (NamedValue dataPoint : category) {
                categoryDataset.setValue(this.scaleNumber(dataPoint.getValue(), data.getScalingFactor()), (Comparable)((Object)dataPoint.getName()), (Comparable)((Object)category.getDomainName()));
            }
        }
        return categoryDataset;
    }

    private AxesLabels getAxesLabels(ChartModel chartModel) {
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        AxesLabels graphLabelsAndFonts = new AxesLabels();
        if (twoAxisPlot.getRangeAxis() != null && twoAxisPlot.getRangeAxis().getLegend() != null && twoAxisPlot.getRangeAxis().getLegend().getText() != null && twoAxisPlot.getRangeAxis().getLegend().getText().trim().length() > 0) {
            graphLabelsAndFonts.rangeAxisLabel = twoAxisPlot.getRangeAxis().getLegend().getText();
        }
        if (twoAxisPlot.getDomainAxis() != null && twoAxisPlot.getDomainAxis().getLegend() != null && twoAxisPlot.getDomainAxis().getLegend().getText() != null && twoAxisPlot.getDomainAxis().getLegend().getText().trim().length() > 0) {
            graphLabelsAndFonts.domainAxisLabel = twoAxisPlot.getDomainAxis().getLegend().getText();
        }
        return graphLabelsAndFonts;
    }

    private List<Integer> getPlotColors(org.pentaho.chart.model.Plot plot) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        if (plot.getPalette() != null) {
            colors.addAll(plot.getPalette());
        }
        ArrayList<Integer> defaultColors = new ArrayList<Integer>(org.pentaho.chart.model.Plot.DEFAULT_PALETTE);
        defaultColors.removeAll(colors);
        colors.addAll(defaultColors);
        return colors;
    }

    private void initCategoryPlot(JFreeChart chart, ChartModel chartModel, final IChartLinkGenerator linkGenerator) {
        Number rangeMax;
        Number rangeMin;
        Axis.LabelOrientation labelOrientation;
        Color color;
        this.initPlot(chart, chartModel);
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        Grid grid = twoAxisPlot.getGrid();
        if (twoAxisPlot.getOrientation() != Plot.Orientation.HORIZONTAL) {
            color = grid.getVerticalLineColor() != null ? new Color(0xFFFFFF & grid.getVerticalLineColor()) : new Color(0xDFDFDF);
            categoryPlot.setDomainGridlinesVisible(grid.getVerticalLinesVisible());
            categoryPlot.setDomainGridlinePaint((Paint)color);
            color = grid.getHorizontalLineColor() != null ? new Color(0xFFFFFF & grid.getHorizontalLineColor()) : new Color(0xDFDFDF);
            categoryPlot.setRangeGridlinesVisible(grid.getHorizontalLinesVisible());
            categoryPlot.setRangeGridlinePaint((Paint)color);
        } else {
            color = grid.getHorizontalLineColor() != null ? new Color(0xFFFFFF & grid.getHorizontalLineColor()) : new Color(0xDFDFDF);
            categoryPlot.setDomainGridlinesVisible(grid.getHorizontalLinesVisible());
            categoryPlot.setDomainGridlinePaint((Paint)color);
            color = grid.getVerticalLineColor() != null ? new Color(0xFFFFFF & grid.getVerticalLineColor()) : new Color(0xDFDFDF);
            categoryPlot.setRangeGridlinesVisible(grid.getVerticalLinesVisible());
            categoryPlot.setRangeGridlinePaint((Paint)color);
        }
        categoryPlot.setDomainGridlineStroke((Stroke)new BasicStroke(1.0f));
        categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(1.0f));
        List<Integer> colors = this.getPlotColors(twoAxisPlot);
        for (int j = 0; j < categoryPlot.getDatasetCount(); ++j) {
            if (linkGenerator != null) {
                categoryPlot.getRenderer(j).setBaseItemURLGenerator(new CategoryURLGenerator(){

                    public String generateURL(CategoryDataset dataset, int series, int category) {
                        return linkGenerator.generateLink(dataset.getRowKey(series).toString(), dataset.getColumnKey(category).toString(), dataset.getValue(series, category));
                    }
                });
            }
            for (int i = 0; i < colors.size(); ++i) {
                categoryPlot.getRenderer(j).setSeriesPaint(i, (Paint)new Color(0xFFFFFF & colors.get(i)));
            }
        }
        Font domainAxisFont = ChartUtils.getFont(twoAxisPlot.getDomainAxis().getFontFamily(), twoAxisPlot.getDomainAxis().getFontStyle(), twoAxisPlot.getDomainAxis().getFontWeight(), twoAxisPlot.getDomainAxis().getFontSize());
        Font rangeAxisFont = ChartUtils.getFont(twoAxisPlot.getRangeAxis().getFontFamily(), twoAxisPlot.getRangeAxis().getFontStyle(), twoAxisPlot.getRangeAxis().getFontWeight(), twoAxisPlot.getRangeAxis().getFontSize());
        Font rangeTitleFont = ChartUtils.getFont(twoAxisPlot.getRangeAxis().getLegend().getFontFamily(), twoAxisPlot.getRangeAxis().getLegend().getFontStyle(), twoAxisPlot.getRangeAxis().getLegend().getFontWeight(), twoAxisPlot.getRangeAxis().getLegend().getFontSize());
        Font domainTitleFont = ChartUtils.getFont(twoAxisPlot.getDomainAxis().getLegend().getFontFamily(), twoAxisPlot.getDomainAxis().getLegend().getFontStyle(), twoAxisPlot.getDomainAxis().getLegend().getFontWeight(), twoAxisPlot.getDomainAxis().getLegend().getFontSize());
        CategoryAxis domainAxis = categoryPlot.getDomainAxis();
        ValueAxis rangeAxis = categoryPlot.getRangeAxis();
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        if (axesLabels.rangeAxisLabel.length() > 0 && rangeTitleFont != null) {
            rangeAxis.setLabelFont(rangeTitleFont);
        }
        if (axesLabels.domainAxisLabel.length() > 0 && domainTitleFont != null) {
            domainAxis.setLabelFont(domainTitleFont);
        }
        if ((labelOrientation = twoAxisPlot.getHorizontalAxis().getLabelOrientation()) != null && labelOrientation != Axis.LabelOrientation.HORIZONTAL) {
            if (twoAxisPlot.getOrientation() == Plot.Orientation.HORIZONTAL) {
                if (labelOrientation == Axis.LabelOrientation.VERTICAL) {
                    rangeAxis.setVerticalTickLabels(true);
                }
            } else {
                switch (labelOrientation) {
                    case VERTICAL: {
                        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                        break;
                    }
                    case DIAGONAL: {
                        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                    }
                }
            }
        }
        if (domainAxisFont != null) {
            domainAxis.setTickLabelFont(domainAxisFont);
        }
        if (rangeAxisFont != null) {
            rangeAxis.setTickLabelFont(rangeAxisFont);
        }
        if ((rangeMin = twoAxisPlot.getRangeAxis().getMinValue()) != null) {
            rangeAxis.setLowerBound(rangeMin.doubleValue());
        }
        if ((rangeMax = twoAxisPlot.getRangeAxis().getMaxValue()) != null) {
            rangeAxis.setUpperBound(rangeMax.doubleValue());
        }
    }

    private void initXYPlot(JFreeChart chart, ChartModel chartModel) {
        Number rangeMax;
        Number rangeMin;
        this.initPlot(chart, chartModel);
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        XYPlot xyPlot = chart.getXYPlot();
        List<Integer> colors = this.getPlotColors(twoAxisPlot);
        for (int i = 0; i < colors.size(); ++i) {
            for (int j = 0; j < xyPlot.getDatasetCount(); ++j) {
                xyPlot.getRenderer(j).setSeriesPaint(i, (Paint)new Color(0xFFFFFF & colors.get(i)));
            }
        }
        Font domainAxisFont = ChartUtils.getFont(twoAxisPlot.getDomainAxis().getFontFamily(), twoAxisPlot.getDomainAxis().getFontStyle(), twoAxisPlot.getDomainAxis().getFontWeight(), twoAxisPlot.getDomainAxis().getFontSize());
        Font rangeAxisFont = ChartUtils.getFont(twoAxisPlot.getRangeAxis().getFontFamily(), twoAxisPlot.getRangeAxis().getFontStyle(), twoAxisPlot.getRangeAxis().getFontWeight(), twoAxisPlot.getRangeAxis().getFontSize());
        Font rangeTitleFont = ChartUtils.getFont(twoAxisPlot.getRangeAxis().getLegend().getFontFamily(), twoAxisPlot.getRangeAxis().getLegend().getFontStyle(), twoAxisPlot.getRangeAxis().getLegend().getFontWeight(), twoAxisPlot.getRangeAxis().getLegend().getFontSize());
        Font domainTitleFont = ChartUtils.getFont(twoAxisPlot.getDomainAxis().getLegend().getFontFamily(), twoAxisPlot.getDomainAxis().getLegend().getFontStyle(), twoAxisPlot.getDomainAxis().getLegend().getFontWeight(), twoAxisPlot.getDomainAxis().getLegend().getFontSize());
        NumberAxis domainAxis = (NumberAxis)xyPlot.getDomainAxis();
        NumberAxis rangeAxis = (NumberAxis)xyPlot.getRangeAxis();
        domainAxis.setAutoRangeIncludesZero(true);
        rangeAxis.setAutoRangeIncludesZero(true);
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        if (axesLabels.rangeAxisLabel.length() > 0 && rangeTitleFont != null) {
            rangeAxis.setLabelFont(rangeTitleFont);
        }
        if (axesLabels.domainAxisLabel.length() > 0 && domainTitleFont != null) {
            domainAxis.setLabelFont(domainTitleFont);
        }
        domainAxis.setVerticalTickLabels(twoAxisPlot.getHorizontalAxis().getLabelOrientation() == Axis.LabelOrientation.VERTICAL);
        if (domainAxisFont != null) {
            domainAxis.setTickLabelFont(domainAxisFont);
        }
        if (rangeAxisFont != null) {
            rangeAxis.setTickLabelFont(rangeAxisFont);
        }
        if ((rangeMin = twoAxisPlot.getRangeAxis().getMinValue()) != null) {
            rangeAxis.setLowerBound(rangeMin.doubleValue());
        }
        if ((rangeMax = twoAxisPlot.getRangeAxis().getMaxValue()) != null) {
            rangeAxis.setUpperBound(rangeMax.doubleValue());
        }
    }

    private void initPlot(JFreeChart chart, ChartModel chartModel) {
        org.pentaho.chart.model.Plot plot = chartModel.getPlot();
        if (plot.getBackground() instanceof Integer) {
            chart.getPlot().setBackgroundPaint((Paint)new Color(0xFFFFFF & (Integer)chartModel.getPlot().getBackground()));
        } else {
            chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        }
        if (plot.getOpacity() != null) {
            chart.getPlot().setForegroundAlpha(chartModel.getPlot().getOpacity().floatValue());
        }
    }

    public JFreeChart makeBarChart(ChartModel chartModel, MultiSeriesDataModel dataModel, IChartLinkGenerator linkGenerator) {
        DefaultCategoryDataset categoryDataset = this.createCategoryDataset(dataModel);
        TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
        String title = "";
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0) {
            title = chartModel.getTitle().getText();
        }
        AxesLabels axesLabels = this.getAxesLabels(chartModel);
        PlotOrientation plotOrientation = twoAxisPlot.getOrientation() == Plot.Orientation.HORIZONTAL ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        boolean showLegend = chartModel.getLegend() != null && chartModel.getLegend().getVisible();
        JFreeChart chart = null;
        chart = BarPlot.BarPlotFlavor.THREED == ((BarPlot)twoAxisPlot).getFlavor() ? ChartFactory.createBarChart3D((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false) : (BarPlot.BarPlotFlavor.STACKED == ((BarPlot)twoAxisPlot).getFlavor() ? ChartFactory.createStackedBarChart((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false) : ChartFactory.createBarChart((String)title, (String)axesLabels.domainAxisLabel, (String)axesLabels.rangeAxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)showLegend, (boolean)true, (boolean)false));
        this.initCategoryPlot(chart, chartModel, linkGenerator);
        this.initChart(chart, chartModel);
        return chart;
    }

    public IOutput makeChart(ChartTableModel data, ChartDocumentContext chartDocumentContext, ChartResult chartResult) {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        CSSConstant currentChartType = this.determineChartType(chartDocument);
        if (currentChartType == ChartSeriesType.UNDEFINED) {
            chartResult.setErrorCode(5);
            chartResult.setDescription(Messages.getErrorString("JFreeChartPlugin.ERROR_0001_CHART_TYPE_INDETERMINABLE"));
        }
        if (currentChartType == ChartSeriesType.BAR) {
            try {
                JFreeChart chart = this.makeBarChart(data, chartDocumentContext);
                return new JFreeChartOutput(chart);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                chartResult.setErrorCode(1);
                chartResult.setDescription(e.getLocalizedMessage());
            }
        } else if (currentChartType == ChartSeriesType.LINE) {
            try {
                return new JFreeChartOutput(this.makeLineChart(data, chartDocumentContext));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                chartResult.setErrorCode(1);
                chartResult.setDescription(e.getLocalizedMessage());
            }
        } else if (currentChartType == ChartSeriesType.AREA) {
            try {
                return new JFreeChartOutput(this.makeAreaChart(data, chartDocumentContext));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                chartResult.setErrorCode(1);
                chartResult.setDescription(e.getLocalizedMessage());
            }
        } else if (currentChartType == ChartSeriesType.PIE) {
            try {
                return new JFreeChartOutput(this.makePieChart(data, chartDocumentContext));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                chartResult.setErrorCode(1);
                chartResult.setDescription(e.getLocalizedMessage());
            }
        } else if (currentChartType == ChartSeriesType.MULTI) {
            try {
                return new JFreeChartOutput(this.makeMultiChart(data, chartDocumentContext));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                chartResult.setErrorCode(1);
                chartResult.setDescription(e.getLocalizedMessage());
            }
        } else if (currentChartType == ChartSeriesType.DIAL) {
            try {
                return new JFreeChartOutput(this.makeDialChart(data, chartDocumentContext));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                chartResult.setErrorCode(1);
                chartResult.setDescription(e.getLocalizedMessage());
            }
        }
        return null;
    }

    public JFreeChart makeAreaChart(ChartTableModel data, ChartDocumentContext chartDocumentContext) {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        JFreeChart chart = this.createAreaChartSubtype(chartDocumentContext, data);
        JFreeChartUtils.setPlotAttributes(chart.getCategoryPlot(), chartDocument);
        return chart;
    }

    private JFreeChart createAreaChartSubtype(ChartDocumentContext chartDocumentContext, ChartTableModel data) {
        JFreeAreaChartGeneratorFactory chartFacEngine = new JFreeAreaChartGeneratorFactory();
        JFreeChart chart = chartFacEngine.createChart(chartDocumentContext, data);
        return chart;
    }

    public JFreeChart makePieChart(ChartTableModel data, ChartDocumentContext chartDocumentContext) {
        JFreePieChartGeneratorFactory chartFacEngine = new JFreePieChartGeneratorFactory();
        JFreeChart chart = chartFacEngine.createChart(chartDocumentContext, data);
        return chart;
    }

    public JFreeChart makeDialChart(ChartTableModel data, ChartDocumentContext chartDocumentContext) {
        JFreeDialChartGeneratorFactory chartFacEngine = new JFreeDialChartGeneratorFactory();
        JFreeChart chart = chartFacEngine.createChart(chartDocumentContext, data);
        return chart;
    }

    public JFreeChart makeBarChart(ChartTableModel data, ChartDocumentContext chartDocumentContext) throws Exception {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        JFreeChart chart = this.createBarChartSubtype(chartDocumentContext, data);
        JFreeChartUtils.setPlotAttributes(chart.getCategoryPlot(), chartDocument);
        return chart;
    }

    private JFreeChart createBarChartSubtype(ChartDocumentContext chartDocumentContext, ChartTableModel data) {
        JFreeBarChartGeneratorFactory chartFacEngine = new JFreeBarChartGeneratorFactory();
        JFreeChart chart = chartFacEngine.createChart(chartDocumentContext, data);
        return chart;
    }

    public JFreeChart makeLineChart(ChartTableModel data, ChartDocumentContext chartDocumentContext) throws Exception {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        JFreeChart chart = this.createLineChartSubtype(chartDocumentContext, data);
        JFreeChartUtils.setPlotAttributes(chart.getCategoryPlot(), chartDocument);
        return chart;
    }

    private JFreeChart createLineChartSubtype(ChartDocumentContext chartDocumentContext, ChartTableModel data) {
        JFreeLineChartGeneratorFactory chartFacEngine = new JFreeLineChartGeneratorFactory();
        JFreeChart chart = chartFacEngine.createChart(chartDocumentContext, data);
        return chart;
    }

    public JFreeChart makeMultiChart(ChartTableModel data, ChartDocumentContext chartDocumentContext) {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        JFreeChart chart = this.createMultiChartSubtype(chartDocumentContext, data);
        JFreeChartUtils.setPlotAttributes(chart.getCategoryPlot(), chartDocument);
        return chart;
    }

    private JFreeChart createMultiChartSubtype(ChartDocumentContext chartDocumentContext, ChartTableModel data) {
        JFreeMultiChartGeneratorFactory chartFacEngine = new JFreeMultiChartGeneratorFactory();
        JFreeChart chart = chartFacEngine.createChart(chartDocumentContext, data);
        return chart;
    }

    public CSSConstant determineChartType(ChartDocument chartDocument) {
        ChartElement[] elements;
        for (ChartElement element : elements = chartDocument.getRootElement().findChildrenByName("series")) {
            CSSValue value = element.getLayoutStyle().getValue(ChartStyleKeys.CHART_TYPE);
            if (value == null) continue;
            if (value.equals(ChartSeriesType.BAR)) {
                return ChartSeriesType.BAR;
            }
            if (value.equals(ChartSeriesType.LINE)) {
                return ChartSeriesType.LINE;
            }
            if (value.equals(ChartSeriesType.AREA)) {
                return ChartSeriesType.AREA;
            }
            if (value.equals(ChartSeriesType.PIE)) {
                return ChartSeriesType.PIE;
            }
            if (value.equals(ChartSeriesType.MULTI)) {
                return ChartSeriesType.MULTI;
            }
            if (!value.equals(ChartSeriesType.DIAL)) continue;
            return ChartSeriesType.DIAL;
        }
        return ChartSeriesType.UNDEFINED;
    }

    protected Stroke getLineStyleStroke(LinePlot.LinePlotFlavor flavor, Integer lineWidth) {
        BasicStroke stroke = null;
        float[] strokeSteps = null;
        if (lineWidth == null || lineWidth <= 0) {
            lineWidth = 1;
        }
        if (flavor != null) {
            switch (flavor) {
                case DOT: {
                    strokeSteps = new float[]{2.0f, 6.0f};
                    break;
                }
                case DASH: {
                    strokeSteps = new float[]{6.0f, 6.0f};
                    break;
                }
                case DASHDOT: {
                    strokeSteps = new float[]{10.0f, 6.0f, 2.0f, 6.0f};
                    break;
                }
                case DASHDOTDOT: {
                    strokeSteps = new float[]{10.0f, 6.0f, 2.0f, 6.0f, 2.0f, 6.0f};
                }
            }
        }
        stroke = strokeSteps != null ? new BasicStroke(lineWidth.intValue(), 1, 1, 1.0f, strokeSteps, 0.0f) : new BasicStroke(lineWidth.intValue());
        return stroke;
    }

    protected Number scaleNumber(Number number, Number scale) {
        Number scaledNumber = number;
        if (number != null && scale != null && !scale.equals(1) && !scale.equals(0)) {
            String fractionalPart;
            int indexOfDecimalPoint;
            int startingSignificantDigits = 0;
            if (!(number instanceof Integer || (indexOfDecimalPoint = number.toString().indexOf(".")) < 0 || (fractionalPart = number.toString().substring(indexOfDecimalPoint + 1)).length() <= 1 && Integer.parseInt(fractionalPart) <= 0)) {
                startingSignificantDigits = fractionalPart.length();
            }
            int preferredSignificantDigits = Math.max(2, Math.min(startingSignificantDigits, 6));
            scaledNumber = number.doubleValue() / scale.doubleValue();
            int scaledSignificantDigits = 0;
            int indexOfDecimalPoint2 = scaledNumber.toString().indexOf(".");
            String fractionalPart2 = scaledNumber.toString().substring(indexOfDecimalPoint2 + 1);
            if (fractionalPart2.length() > 1 || Integer.parseInt(fractionalPart2) > 0) {
                scaledSignificantDigits = fractionalPart2.length();
            }
            if (scaledSignificantDigits > preferredSignificantDigits) {
                double multiplier = Math.pow(10.0, preferredSignificantDigits);
                scaledNumber = (double)Math.round(scaledNumber.doubleValue() * multiplier) / multiplier;
            }
        }
        return scaledNumber;
    }

    private class AxesLabels {
        String domainAxisLabel = "";
        String rangeAxisLabel = "";

        private AxesLabels() {
        }
    }
}

