/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.dataset;

import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.DefaultIntervalCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.dataset.IJFreeDatasetGenerator;
import org.pentaho.chart.plugin.jfreechart.dataset.JFreeDefaultCategoryDatasetGenerator;
import org.pentaho.chart.plugin.jfreechart.dataset.JFreeDefaultIntervalCategoryDatasetGenerator;
import org.pentaho.chart.plugin.jfreechart.dataset.JFreeDefaultPieDatasetGenerator;
import org.pentaho.chart.plugin.jfreechart.dataset.JFreeDefaultValueDatasetGenerator;

public class DatasetGeneratorFactory {
    private final String DATASET = "dataset";
    private final String TYPE = "type";
    private final String CATEGORICAL = "categorical";
    private final String XY = "xy";
    private final String VALUE = "value";
    private final String TIME_SERIES = "timeseries";
    private final String INTERVAL = "interval";
    private final String PIE = "pie";

    public DefaultPieDataset createDefaultPieDataset(ChartDocumentContext chartDocContext, ChartTableModel data) {
        Dataset dataset = this.createDataset(chartDocContext, data);
        DefaultPieDataset pieDataset = null;
        if (dataset != null && dataset instanceof DefaultPieDataset) {
            pieDataset = (DefaultPieDataset)dataset;
        }
        return pieDataset;
    }

    public DefaultCategoryDataset createDefaultCategoryDataset(ChartDocumentContext chartDocContext, ChartTableModel data) {
        Dataset dataset = this.createDataset(chartDocContext, data);
        DefaultCategoryDataset categoryDataset = null;
        if (dataset != null && dataset instanceof DefaultCategoryDataset) {
            categoryDataset = (DefaultCategoryDataset)dataset;
        }
        return categoryDataset;
    }

    public DefaultCategoryDataset createDefaultCategoryDataset(ChartDocumentContext chartDocContext, ChartTableModel data, Integer[] columnPosArr) throws IllegalArgumentException, IllegalStateException {
        Dataset dataset = this.createDataset(chartDocContext, data, columnPosArr);
        DefaultCategoryDataset categoryDataset = null;
        if (dataset != null && dataset instanceof DefaultCategoryDataset) {
            categoryDataset = (DefaultCategoryDataset)dataset;
        }
        return categoryDataset;
    }

    public DefaultIntervalCategoryDataset createDefaultIntervalCategoryDataset() {
        return null;
    }

    public Dataset createDataset(ChartDocumentContext chartDocContext, ChartTableModel data) throws IllegalArgumentException, IllegalStateException {
        Dataset dataset = null;
        if (chartDocContext == null || data == null) {
            throw new IllegalArgumentException("Arguments cannot be null. ChartDocumentContext: " + chartDocContext + ", ChartTableModel: " + data);
        }
        ChartDocument chartDoc = chartDocContext.getChartDocument();
        if (chartDoc == null) {
            throw new IllegalStateException("Chart document cannot be null!");
        }
        String datasetType = this.getDatasetType(chartDoc.getPlotElement());
        IJFreeDatasetGenerator datasetGenerator = null;
        if (datasetType != null) {
            if ("categorical".equalsIgnoreCase(datasetType)) {
                datasetGenerator = new JFreeDefaultCategoryDatasetGenerator();
            } else if ("pie".equalsIgnoreCase(datasetType)) {
                datasetGenerator = new JFreeDefaultPieDatasetGenerator();
            } else if (!"xy".equalsIgnoreCase(datasetType)) {
                if ("value".equalsIgnoreCase(datasetType)) {
                    datasetGenerator = new JFreeDefaultValueDatasetGenerator();
                } else if (!"timeseries".equalsIgnoreCase(datasetType) && "interval".equalsIgnoreCase(datasetType)) {
                    datasetGenerator = new JFreeDefaultIntervalCategoryDatasetGenerator();
                }
            }
        } else {
            datasetGenerator = new JFreeDefaultCategoryDatasetGenerator();
        }
        if (datasetGenerator != null) {
            dataset = datasetGenerator.createDataset(chartDocContext, data);
        }
        return dataset;
    }

    private Dataset createDataset(ChartDocumentContext chartDocContext, ChartTableModel data, Integer[] columnPosArr) throws IllegalArgumentException, IllegalStateException {
        Dataset dataset = null;
        if (chartDocContext != null && data != null) {
            ChartDocument chartDoc = chartDocContext.getChartDocument();
            if (chartDoc == null) {
                throw new IllegalStateException("Chart document cannot be null!");
            }
            String datasetType = this.getDatasetType(chartDoc.getPlotElement());
            IJFreeDatasetGenerator datasetGenerator = null;
            if (datasetType != null) {
                if ("categorical".equalsIgnoreCase(datasetType)) {
                    datasetGenerator = new JFreeDefaultCategoryDatasetGenerator();
                } else if (!"xy".equalsIgnoreCase(datasetType) && !"value".equalsIgnoreCase(datasetType) && !"timeseries".equalsIgnoreCase(datasetType) && "interval".equalsIgnoreCase(datasetType)) {
                    datasetGenerator = new JFreeDefaultIntervalCategoryDatasetGenerator();
                }
            } else {
                datasetGenerator = new JFreeDefaultCategoryDatasetGenerator();
            }
            if (datasetGenerator != null) {
                dataset = datasetGenerator.createDataset(chartDocContext, data, columnPosArr);
            }
        } else {
            throw new IllegalArgumentException("Arguments cannot be null. ChartDocumentContext: " + chartDocContext + ", ChartTableModel: " + data);
        }
        return dataset;
    }

    private String getDatasetType(ChartElement plotElement) {
        int childCount = plotElement.getChildCount();
        ChartElement plotChildElement = plotElement.getFirstChildItem();
        for (int i = 0; i < childCount; ++i) {
            if ("dataset".equals(plotChildElement.getTagName())) {
                return (String)plotChildElement.getAttribute("type");
            }
            plotChildElement = plotChildElement.getNextItem();
        }
        return null;
    }
}

