/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.utils;

import java.awt.Color;
import java.awt.GradientPaint;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.pentaho.chart.ChartUtils;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartGradientType;
import org.pentaho.chart.css.styles.ChartItemLabelVisibleType;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;

public class JFreeChartUtils
extends ChartUtils {
    private static final Log logger = LogFactory.getLog(JFreeChartUtils.class);
    private static final char SEPERATOR = '/';

    private JFreeChartUtils() {
    }

    public static Object getRawRowName(ChartTableModel data, ChartDocument chartDocument, int row) {
        StringBuffer syntheticColumnName = new StringBuffer();
        if (JFreeChartUtils.getIsStackedGrouped(chartDocument)) {
            ChartElement currentGroup = JFreeChartUtils.getBaseStackedGroupElement(chartDocument);
            while (currentGroup != null) {
                String columnName = currentGroup.getAttribute("column-name").toString();
                int columnIndex = data.findColumn(columnName);
                syntheticColumnName.append(data.getValueAt(row, columnIndex)).append('/');
                currentGroup = JFreeChartUtils.getChildGroup(currentGroup);
            }
        }
        return syntheticColumnName.append(data.getRowMetadata(row, "row-name")).toString();
    }

    public static String getColumnName(ChartTableModel data, int column) {
        return data.getColumnName(column) == null ? Integer.toBinaryString(column) : data.getColumnName(column);
    }

    public static double getScale(ChartDocument chartDocument) {
        return ((CSSNumericValue)chartDocument.getPlotElement().getLayoutStyle().getValue(ChartStyleKeys.SCALE_NUM)).getValue();
    }

    public static int getSeriesColumn(ChartElement seriesElement, ChartTableModel data, int columnDefault) {
        Object positionAttr = seriesElement.getAttribute("column-pos");
        int column = positionAttr != null ? Integer.parseInt(positionAttr.toString()) : ((positionAttr = seriesElement.getAttribute("column-name")) != null ? JFreeChartUtils.lookupPosition(data, positionAttr.toString()) : columnDefault);
        return column;
    }

    public static int getSeriesRow(ChartElement seriesElement, int rowDefault) {
        Object positionAttr = seriesElement.getAttribute("row-pos");
        int row = positionAttr != null ? Integer.parseInt(positionAttr.toString()) : rowDefault;
        return row;
    }

    private static int lookupPosition(ChartTableModel data, String columnName) {
        int colCount = data.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (!data.getColumnName(i).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public static boolean getShowUrls(ChartDocument chartDocument) {
        LayoutStyle layoutStyle;
        CSSValue value;
        ChartElement plotElement = chartDocument.getPlotElement();
        boolean showURL = false;
        if (plotElement != null && (value = (layoutStyle = plotElement.getLayoutStyle()).getValue(ChartStyleKeys.DRILL_URL)) != null && !value.getCSSText().equalsIgnoreCase("none")) {
            showURL = true;
        }
        return showURL;
    }

    public static void setPlotAttributes(CategoryPlot categoryPlot, ChartDocument chartDocument) {
        JFreeChartUtils.setURLGeneration(categoryPlot.getRenderer(), chartDocument);
    }

    public static void setURLGeneration(CategoryItemRenderer renderer, ChartDocument chartDocument) {
        if (JFreeChartUtils.getShowUrls(chartDocument)) {
            String URLPrefix = JFreeChartUtils.getURLText(chartDocument);
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator(URLPrefix));
        }
    }

    public static String getURLText(ChartDocument chartDocument) {
        LayoutStyle layoutStyle;
        CSSValue value;
        ChartElement plotElement = chartDocument.getPlotElement();
        if (plotElement != null && (value = (layoutStyle = plotElement.getLayoutStyle()).getValue(ChartStyleKeys.DRILL_URL)) != null && !value.getCSSText().equalsIgnoreCase("none")) {
            return value.getCSSText();
        }
        return null;
    }

    public static GradientPaint getGradientPaint(ChartElement ce) {
        GradientPaint gradPaint = null;
        LayoutStyle layoutStyle = ce.getLayoutStyle();
        if (layoutStyle != null) {
            CSSValue gradType = layoutStyle.getValue(ChartStyleKeys.GRADIENT_TYPE);
            Color[] gradColors = JFreeChartUtils.getGradientColors(ce);
            if (ChartGradientType.POINTS.equals((Object)gradType)) {
                CSSValuePair gradStart = (CSSValuePair)layoutStyle.getValue(ChartStyleKeys.GRADIENT_START);
                CSSValuePair gradEnd = (CSSValuePair)layoutStyle.getValue(ChartStyleKeys.GRADIENT_END);
                float x1 = (float)((CSSNumericValue)gradStart.getFirstValue()).getValue();
                float y1 = (float)((CSSNumericValue)gradStart.getSecondValue()).getValue();
                float x2 = (float)((CSSNumericValue)gradEnd.getFirstValue()).getValue();
                float y2 = (float)((CSSNumericValue)gradEnd.getSecondValue()).getValue();
                gradPaint = new GradientPaint(x1, y1, gradColors[0], x2, y2, gradColors[1]);
            } else if (!gradType.equals(ChartGradientType.NONE)) {
                gradPaint = new GradientPaint(0.0f, 0.0f, gradColors[0], 0.0f, 0.0f, gradColors[1]);
            }
        }
        return gradPaint;
    }

    private static Color[] getGradientColors(ChartElement element) {
        Color[] gradientColor = null;
        LayoutStyle layoutStyle = element.getLayoutStyle();
        if (layoutStyle != null) {
            CSSValuePair valuePair = (CSSValuePair)layoutStyle.getValue(ChartStyleKeys.GRADIENT_COLOR);
            CSSValue colorValue1 = valuePair.getFirstValue();
            CSSValue colorValue2 = valuePair.getSecondValue();
            Color color1 = JFreeChartUtils.getColorFromCSSValue(colorValue1);
            Color color2 = JFreeChartUtils.getColorFromCSSValue(colorValue2);
            gradientColor = new Color[]{color1, color2};
        }
        return gradientColor;
    }

    public static Color getColorFromCSSValue(CSSValue value) {
        Color gradientColor = null;
        if (value instanceof CSSFunctionValue) {
            CSSFunctionValue func1 = (CSSFunctionValue)value;
            CSSValue[] rgbArr = func1.getParameters();
            try {
                int red = (int)((CSSNumericValue)rgbArr[0]).getValue();
                int green = (int)((CSSNumericValue)rgbArr[1]).getValue();
                int blue = (int)((CSSNumericValue)rgbArr[2]).getValue();
                gradientColor = new Color(red, green, blue);
            }
            catch (NumberFormatException ne) {
                logger.info((Object)"Color values defined were incorrect.", (Throwable)ne);
            }
        } else if (value instanceof CSSColorValue) {
            CSSColorValue colorValue = (CSSColorValue)value;
            gradientColor = new Color(colorValue.getRed(), colorValue.getGreen(), colorValue.getBlue());
        }
        return gradientColor;
    }

    public static StandardGradientPaintTransformer getStandardGradientPaintTrans(ChartElement ce) {
        StandardGradientPaintTransformer trans = null;
        LayoutStyle layoutStyle = ce.getLayoutStyle();
        if (layoutStyle != null) {
            CSSValue gradType = layoutStyle.getValue(ChartStyleKeys.GRADIENT_TYPE);
            if (ChartGradientType.HORIZONTAL.equals((Object)gradType)) {
                trans = new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL);
            } else if (ChartGradientType.VERTICAL.equals((Object)gradType)) {
                trans = new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL);
            } else if (ChartGradientType.CENTER_HORIZONTAL.equals((Object)gradType)) {
                trans = new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL);
            } else if (ChartGradientType.CENTER_VERTICAL.equals((Object)gradType)) {
                trans = new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL);
            }
        }
        return trans;
    }

    public static boolean showItemLabel(ChartElement element) {
        boolean showItemLabel = false;
        CSSValue itemLabelVisible = element.getLayoutStyle().getValue(ChartStyleKeys.ITEM_LABEL_VISIBLE);
        if (ChartItemLabelVisibleType.VISIBLE.equals((Object)itemLabelVisible)) {
            showItemLabel = true;
        }
        return showItemLabel;
    }

    public static float getMaximumBarWidth(ChartElement seriesElement) {
        CSSNumericValue maxWidthNumValue;
        float maxWidth = 0.0f;
        LayoutStyle layoutStyle = seriesElement.getLayoutStyle();
        CSSValue maxWidthValue = layoutStyle.getValue(ChartStyleKeys.BAR_MAX_WIDTH);
        if (maxWidthValue instanceof CSSNumericValue && CSSNumericType.PERCENTAGE.equals((Object)(maxWidthNumValue = (CSSNumericValue)maxWidthValue).getType())) {
            maxWidth = (float)(maxWidthNumValue.getValue() / 100.0);
        }
        return maxWidth;
    }

    public static ChartElement getBaseStackedGroupElement(ChartDocument chartDocument) {
        ChartElement[] groupElements = chartDocument.getGroupChartElements();
        if (groupElements.length > 0) {
            return groupElements[0];
        }
        return null;
    }

    public static ChartElement getChildGroup(ChartElement parentGroup) {
        ChartElement[] groupElements = parentGroup.findChildrenByName("group");
        if (groupElements.length > 0) {
            return groupElements[0];
        }
        return null;
    }

    public static boolean getIsStackedGrouped(ChartDocument chartDocument) {
        return JFreeChartUtils.getBaseStackedGroupElement(chartDocument) != null;
    }

    public static KeyToGroupMap createKeyToGroupMap(ChartDocument chartDocument, ChartTableModel data, CategoryDataset dataSet) {
        ChartElement groupElement = JFreeChartUtils.getBaseStackedGroupElement(chartDocument);
        HashSet<String> matchSet = new HashSet<String>();
        int rowCount = data.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            StringBuffer keyStr = new StringBuffer();
            int n = JFreeChartUtils.getGroupDepth(groupElement);
            for (int i = 0; i < n; ++i) {
                String columnName = groupElement.getAttribute("column-name").toString();
                int columnNum = data.findColumn(columnName);
                keyStr.append(data.getValueAt(row, columnNum)).append('/');
                groupElement = JFreeChartUtils.getChildGroup(groupElement);
            }
            matchSet.add(keyStr.toString());
            groupElement = JFreeChartUtils.getBaseStackedGroupElement(chartDocument);
        }
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap();
        for (Object e : matchSet) {
            String matchStr = e.toString();
            Iterator rowHeaderIterator = dataSet.getRowKeys().iterator();
            while (rowHeaderIterator.hasNext()) {
                String rowHeader = e.toString();
                if (!rowHeader.startsWith(matchStr)) continue;
                keyToGroupMap.mapKeyToGroup((Comparable)((Object)rowHeader), (Comparable)((Object)matchStr));
            }
        }
        return keyToGroupMap;
    }

    private static int getGroupDepth(ChartElement groupElementParam) {
        int depth = 0;
        if (groupElementParam != null) {
            ChartElement groupElement = groupElementParam;
            while (groupElement != null) {
                ++depth;
                groupElement = JFreeChartUtils.getChildGroup(groupElement);
            }
        }
        return depth;
    }
}

