/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.utils;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartMarkerShapeType;
import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class ShapeFactory {
    private static ShapeFactory shapeFacObj;

    private ShapeFactory() {
    }

    public static synchronized ShapeFactory getInstance() {
        if (shapeFacObj == null) {
            shapeFacObj = new ShapeFactory();
        }
        return shapeFacObj;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public synchronized Shape getShape(ChartElement element) {
        if (element == null) {
            return null;
        }
        CSSValue shapeValue = element.getLayoutStyle().getValue(ChartStyleKeys.MARKER_SHAPE);
        double height = StyleSheetUtility.convertLengthToDouble((CSSValue)element.getLayoutStyle().getValue(ChartStyleKeys.MARKER_HEIGHT), (int)72);
        double width = StyleSheetUtility.convertLengthToDouble((CSSValue)element.getLayoutStyle().getValue(ChartStyleKeys.MARKER_WIDTH), (int)72);
        if (ChartMarkerShapeType.RECTANGLE.equals((Object)shapeValue)) {
            return new Rectangle2D.Double(-(width / 2.0), -(height / 2.0), width, height);
        }
        if (ChartMarkerShapeType.ELLIPSE.equals((Object)shapeValue)) {
            return new Ellipse2D.Double(-(width / 2.0), -(height / 2.0), width, height);
        }
        return null;
    }
}

