/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.openflashchart;

import java.util.EnumSet;
import java.util.Set;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.IChartLinkGenerator;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.plugin.AbstractChartPlugin;
import org.pentaho.chart.plugin.api.ChartResult;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.openflashchart.OpenFlashChartFactoryEngine;

public class OpenFlashChartPlugin
extends AbstractChartPlugin {
    public static final String PLUGIN_ID = "OpenFlashChart";
    private OpenFlashChartFactoryEngine chartFactory = new OpenFlashChartFactoryEngine();
    private static final Set<IOutput.OutputTypes> supportedOutputs = EnumSet.of(IOutput.OutputTypes.DATA_TYPE_STREAM);

    @Override
    public IOutput renderChartDocument(ChartModel chartModel, IChartDataModel chartTableModel) {
        return this.renderChartDocument(chartModel, chartTableModel, null);
    }

    @Override
    public IOutput renderChartDocument(ChartModel chartModel, IChartDataModel chartTableModel, IChartLinkGenerator chartLinkGenerator) {
        return this.chartFactory.makeChart(chartModel, chartTableModel, chartLinkGenerator);
    }

    @Override
    public IOutput renderChartDocument(ChartDocumentContext chartDocumentContext, ChartTableModel data) {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        ChartResult chartResult = this.validateChartDocument(chartDocument);
        if (chartResult.getErrorCode() == 0) {
            return this.chartFactory.makeChart(data, chartDocumentContext, chartResult);
        }
        return null;
    }

    @Override
    public Set<IOutput.OutputTypes> getSupportedOutputs() {
        return supportedOutputs;
    }

    @Override
    public String getPluginId() {
        return PLUGIN_ID;
    }

    protected OpenFlashChartFactoryEngine getChartFactory() {
        return this.chartFactory;
    }

    protected void setChartFactory(OpenFlashChartFactoryEngine chartFactory) {
        this.chartFactory = chartFactory;
    }
}

